/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.ArrayList;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.section.details.DetailedStepHookDisplay;

public class StackTraceDisplay {
    private Executable executable;
    private Color color;
    private final float fontsize = 9.0f;
    private static final int START_EXCEPTION_LINES = 4;
    private static final int FINISH_EXCEPTION_LINES = 3;
    private static final int MAX_LINES_PER_EXCEPTION = 3;

    public AbstractCell display() {
        Object line;
        Object lines;
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        TextLengthOptimizer textOptimizer = TextLengthOptimizer.builder().font(DetailedStepHookDisplay.STEP_HOOK_TEXT_FONT).fontsize(9).availableSpace(572.0f).maxLines(3).build();
        String[] displayLines = new ArrayList();
        boolean trimStackLine = false;
        boolean extraLines = false;
        if (this.executable.getErrorMessage() != null && !this.executable.getErrorMessage().isEmpty()) {
            lines = this.executable.getErrorMessage().split("\\r?\\n");
            Object nonTraceLine = "";
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                line = stringArray[n2];
                if (((String)line).startsWith("\tat")) {
                    if (!((String)nonTraceLine).isEmpty()) {
                        displayLines.add(nonTraceLine);
                        nonTraceLine = "";
                    }
                    displayLines.add(line);
                } else {
                    nonTraceLine = ((String)nonTraceLine).isEmpty() ? line : String.valueOf(nonTraceLine) + " " + (String)line;
                }
                ++n2;
            }
        }
        if (!displayLines.isEmpty()) {
            lines = displayLines;
            if (displayLines.size() > 7) {
                extraLines = true;
                lines = displayLines.subList(0, 4);
                lines.add(".....");
                lines.addAll(displayLines.subList(displayLines.size() - 3, displayLines.size()));
            }
            line = lines.iterator();
            while (line.hasNext()) {
                String line2 = (String)line.next();
                paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(sanitizer.sanitizeText(textOptimizer.optimizeTextLines(line2))).color(this.color).build()).appendNewLine();
                if (trimStackLine || !textOptimizer.isTextTrimmed()) continue;
                trimStackLine = true;
            }
        }
        String croppedMsgSuffix = " to fit in the available space.";
        String message = "";
        if (trimStackLine) {
            message = "* Each stack line length is trimmed to 3 lines";
        }
        if (extraLines) {
            String capitalizeText = trimStackLine ? " and f" : "* F";
            message = String.valueOf(message) + capitalizeText + "irst " + 4 + " and last " + 3 + " stack lines are displayed";
        }
        if (!message.isEmpty()) {
            paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(String.valueOf(message) + " to fit in the available space.").color(this.color).build());
        }
        return ParagraphCell.builder().paragraph(paragraphBuilder.build()).lineSpacing(1.1f).build();
    }

    StackTraceDisplay(Executable executable, Color color) {
        this.executable = executable;
        this.color = color;
    }

    public static StackTraceDisplayBuilder builder() {
        return new StackTraceDisplayBuilder();
    }

    public static class StackTraceDisplayBuilder {
        private Executable executable;
        private Color color;

        StackTraceDisplayBuilder() {
        }

        public StackTraceDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public StackTraceDisplayBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public StackTraceDisplay build() {
            return new StackTraceDisplay(this.executable, this.color);
        }

        public String toString() {
            return "StackTraceDisplay.StackTraceDisplayBuilder(executable=" + this.executable + ", color=" + this.color + ")";
        }
    }
}

