/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.section.details.LogMessageDisplay;
import tech.grasshopper.pdf.section.details.MediaDisplay;
import tech.grasshopper.pdf.section.details.StackTraceDisplay;
import tech.grasshopper.pdf.structure.Display;

public abstract class ExecutableDisplay
extends Display {
    protected Executable executable;
    protected Table.TableBuilder tableBuilder;
    protected int sNo;

    @Override
    public void display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        int rowSpan = this.getRowSpan();
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().rowSpan(rowSpan)).text(this.getSerialNumber()).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(sanitizer.sanitizeText(this.executableName())).textColor(this.executableNameColor())).backgroundColor(this.executableBackgroundColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().rowSpan(rowSpan)).text(this.executable.getStatus().toString()).textColor(this.statusColor(this.executable.getStatus()))).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().rowSpan(rowSpan)).text(this.getDuration()).textColor(this.reportConfig.getDetailedStepHookConfig().durationColor())).build()).build());
        this.displaySubTypeDetails();
        this.displayLogMessage();
        this.displayStackTrace();
        this.displayMedia();
    }

    protected abstract int processSNo(int var1);

    protected abstract String getSerialNumber();

    protected abstract String getDuration();

    protected abstract String executableName();

    protected abstract Color executableNameColor();

    protected abstract Color executableBackgroundColor();

    protected int getSubTypeRowSpanCount() {
        return 0;
    }

    protected void displaySubTypeDetails() {
    }

    protected int getRowSpan() {
        int rowSpan = 1 + this.getSubTypeRowSpanCount();
        if (!this.executable.getOutput().isEmpty()) {
            ++rowSpan;
        }
        if (this.executable.getErrorMessage() != null && !this.executable.getErrorMessage().isEmpty()) {
            ++rowSpan;
        }
        if (!this.executable.getMedia().isEmpty()) {
            ++rowSpan;
        }
        return rowSpan;
    }

    protected void displayLogMessage() {
        if (this.executable.getOutput().isEmpty()) {
            return;
        }
        this.tableBuilder.addRow(Row.builder().add(LogMessageDisplay.builder().executable(this.executable).color(this.reportConfig.getDetailedStepHookConfig().logMsgColor()).build().display()).build());
    }

    protected void displayStackTrace() {
        if (this.executable.getErrorMessage() == null || this.executable.getErrorMessage().isEmpty()) {
            return;
        }
        this.tableBuilder.addRow(Row.builder().add(StackTraceDisplay.builder().executable(this.executable).color(this.reportConfig.getDetailedStepHookConfig().errorMsgColor()).build().display()).build());
    }

    protected void displayMedia() {
        if (this.executable.getMedia().isEmpty()) {
            return;
        }
        this.tableBuilder.addRow(Row.builder().add(MediaDisplay.builder().executable(this.executable).document(this.document).build().display()).build());
    }

    protected ExecutableDisplay(ExecutableDisplayBuilder<?, ?> b) {
        super(b);
        this.executable = ((ExecutableDisplayBuilder)b).executable;
        this.tableBuilder = ((ExecutableDisplayBuilder)b).tableBuilder;
        this.sNo = ((ExecutableDisplayBuilder)b).sNo;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getSNo() {
        return this.sNo;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setSNo(int sNo) {
        this.sNo = sNo;
    }

    @Override
    public String toString() {
        return "ExecutableDisplay(executable=" + this.getExecutable() + ", tableBuilder=" + this.getTableBuilder() + ", sNo=" + this.getSNo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutableDisplay)) {
            return false;
        }
        ExecutableDisplay other = (ExecutableDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Executable this$executable = this.getExecutable();
        Executable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !this$executable.equals(other$executable)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        return this.getSNo() == other.getSNo();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExecutableDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Executable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : $executable.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        result = result * 59 + this.getSNo();
        return result;
    }

    public static abstract class ExecutableDisplayBuilder<C extends ExecutableDisplay, B extends ExecutableDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Executable executable;
        private Table.TableBuilder tableBuilder;
        private int sNo;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B executable(Executable executable) {
            this.executable = executable;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B sNo(int sNo) {
            this.sNo = sNo;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ExecutableDisplay.ExecutableDisplayBuilder(super=" + super.toString() + ", executable=" + this.executable + ", tableBuilder=" + this.tableBuilder + ", sNo=" + this.sNo + ")";
        }
    }
}

