/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Row;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.tablecell.TableWithinTableCell;

public class DataTableDisplay {
    private Step step;
    private Color textColor;
    private Color backgroundColor;
    private final int fontsize = 9;
    private boolean rowsCropped;
    private boolean columnsCropped;
    private boolean cellTextCropped;
    private List<Float> maximumColumnTextWidths;
    private static final int MAX_ROW_COUNT = 5;
    private static final float MAX_COLUMN_WIDTH = 100.0f;
    private static final float PADDING = 3.0f;
    private static final float INDICATOR_COLUMN_WIDTH = 4.0f;
    private static final float AVAILABLE_COLUMN_WIDTH = 572.0f;

    public AbstractCell display() {
        List<Row> rows = this.calculateRowCount();
        this.maximumColumnTextWidths = this.maximumColumnWidths(rows);
        ArrayList<Float> resizedColumnTextWidth = new ArrayList<Float>(this.maximumColumnTextWidths);
        this.resizeColumnWidth(resizedColumnTextWidth, false);
        List<Float> columnTextWidths = this.removeExtraColumns(resizedColumnTextWidth);
        return this.createDataTable(rows, columnTextWidths);
    }

    private List<Row> calculateRowCount() {
        List<Row> rows = this.step.getRows();
        int displayRows = rows.size();
        if (rows.size() > 5) {
            displayRows = 5;
            this.rowsCropped = true;
        }
        return rows.subList(0, displayRows);
    }

    private List<Float> maximumColumnWidths(List<Row> rows) {
        Float[][] textWidths = new Float[rows.get(0).getCells().size()][rows.size()];
        int i = 0;
        while (i < rows.size()) {
            Row row = rows.get(i);
            int j = 0;
            while (j < row.getCells().size()) {
                textWidths[j][i] = Float.valueOf(PdfUtil.getStringWidth((String)row.getCells().get(j), (PDFont)ReportFont.REGULAR_FONT, (int)9));
                ++j;
            }
            ++i;
        }
        ArrayList<Float> maxColWidths = new ArrayList<Float>();
        Float[][] floatArray = textWidths;
        int n = textWidths.length;
        int n2 = 0;
        while (n2 < n) {
            Float[] width = floatArray[n2];
            maxColWidths.add(Collections.max(Arrays.asList(width)));
            ++n2;
        }
        return maxColWidths;
    }

    private void resizeColumnWidth(List<Float> columnMaxWidths, boolean removedColumn) {
        float availableWidth = 572.0f - (float)columnMaxWidths.size() * 6.0f;
        if (removedColumn) {
            availableWidth -= 10.0f;
        }
        if (((Float)columnMaxWidths.stream().reduce(Float::sum).get()).floatValue() > availableWidth && columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).count() > 0L) {
            float widthToFitIn = availableWidth - columnMaxWidths.stream().filter(w -> w.floatValue() <= 100.0f).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
            float widthToAdjust = columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).reduce(Float::sum).get().floatValue();
            float reductionFactor = widthToFitIn / widthToAdjust;
            int i = 0;
            while (i < columnMaxWidths.size()) {
                if (columnMaxWidths.get(i).floatValue() > 100.0f) {
                    float resizedWidth = columnMaxWidths.get(i).floatValue() * reductionFactor;
                    resizedWidth = resizedWidth > 100.0f ? resizedWidth : 100.0f;
                    columnMaxWidths.set(i, Float.valueOf(resizedWidth));
                }
                ++i;
            }
        }
        if (((Float)columnMaxWidths.stream().reduce(Float::sum).get()).floatValue() > availableWidth && columnMaxWidths.stream().filter(w -> w.floatValue() > 100.0f).count() > 0L) {
            this.resizeColumnWidth(columnMaxWidths, false);
        }
    }

    private List<Float> removeExtraColumns(List<Float> resizedColumnWidths) {
        float colSize = ((Float)resizedColumnWidths.stream().reduce(Float::sum).get()).floatValue();
        ArrayList<Float> columnWidths = new ArrayList<Float>(resizedColumnWidths);
        float width = 0.0f;
        if (colSize > 572.0f - (float)resizedColumnWidths.size() * 6.0f) {
            int i = 0;
            while (i < resizedColumnWidths.size()) {
                if ((width += resizedColumnWidths.get(i).floatValue()) > 572.0f - (float)(i + 1) * 6.0f) {
                    columnWidths = new ArrayList<Float>(this.maximumColumnTextWidths.subList(0, i));
                    this.resizeColumnWidth(columnWidths, true);
                    this.columnsCropped = true;
                    break;
                }
                ++i;
            }
        }
        return columnWidths;
    }

    private AbstractCell createDataTable(List<Row> rows, List<Float> columnTextWidths) {
        Table.TableBuilder tableBuilder = Table.builder().backgroundColor(this.backgroundColor).font(ReportFont.REGULAR_FONT).fontSize(Integer.valueOf(9)).borderColor(Color.GRAY).borderWidth(1.0f).padding(3.0f);
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        TextLengthOptimizer optimizer = TextLengthOptimizer.builder().font(ReportFont.REGULAR_FONT).fontsize(9).build();
        this.addColumnWidthsToTable(tableBuilder, columnTextWidths);
        boolean firstRow = true;
        for (Row row : rows) {
            Row.RowBuilder rowBuilder = org.vandeseer.easytable.structure.Row.builder();
            int i = 0;
            while (i < columnTextWidths.size()) {
                optimizer.setAvailableSpace(columnTextWidths.get(i).floatValue());
                rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().textColor(this.textColor)).text(sanitizer.sanitizeText(optimizer.optimizeText(row.getCells().get(i)))).build());
                if (optimizer.isTextTrimmed()) {
                    this.cellTextCropped = optimizer.isTextTrimmed();
                }
                ++i;
            }
            this.croppedColumnIndicatorCells(rowBuilder, firstRow);
            if (firstRow) {
                firstRow = false;
            }
            tableBuilder.addRow(rowBuilder.build());
        }
        this.croppedMessage(tableBuilder, columnTextWidths);
        return ((TableWithinTableCell.TableWithinTableCellBuilder)((Object)TableWithinTableCell.builder().table(tableBuilder.build()))).build();
    }

    private void addColumnWidthsToTable(Table.TableBuilder tableBuilder, List<Float> columnTextWidths) {
        columnTextWidths.forEach(w -> {
            Table.TableBuilder tableBuilder2 = tableBuilder.addColumnOfWidth(w.floatValue() + 6.0f);
        });
        if (this.columnsCropped) {
            tableBuilder.addColumnOfWidth(10.0f);
        }
    }

    private void croppedColumnIndicatorCells(Row.RowBuilder rowBuilder, boolean firstRow) {
        if (this.columnsCropped) {
            if (firstRow) {
                rowBuilder.add((AbstractCell)TextCell.builder().text("*").build());
            } else {
                rowBuilder.add((AbstractCell)TextCell.builder().text("").build());
            }
        }
    }

    private void croppedMessage(Table.TableBuilder tableBuilder, List<Float> columnTextWidths) {
        if (!(this.rowsCropped || this.cellTextCropped || this.columnsCropped)) {
            return;
        }
        String croppedMsgPrefix = "* The";
        String croppedMsgSuffix = "have been cropped to fit in the available space.";
        String message = "";
        int colSpan = columnTextWidths.size();
        if (this.rowsCropped) {
            message = " data row(s), maximum 5, ";
        }
        if (this.cellTextCropped) {
            if (this.rowsCropped) {
                message = String.valueOf(message) + "and";
            }
            message = String.valueOf(message) + " data cell text(s) ";
        }
        if (this.columnsCropped) {
            if (this.rowsCropped || this.cellTextCropped) {
                message = String.valueOf(message) + "and";
            }
            message = String.valueOf(message) + " extra column(s) ";
            ++colSpan;
        }
        tableBuilder.addRow(org.vandeseer.easytable.structure.Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("* The" + message + "have been cropped to fit in the available space.").colSpan(colSpan)).textColor(this.textColor)).build()).build());
    }

    DataTableDisplay(Step step, Color textColor, Color backgroundColor, boolean rowsCropped, boolean columnsCropped, boolean cellTextCropped, List<Float> maximumColumnTextWidths) {
        this.step = step;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.rowsCropped = rowsCropped;
        this.columnsCropped = columnsCropped;
        this.cellTextCropped = cellTextCropped;
        this.maximumColumnTextWidths = maximumColumnTextWidths;
    }

    public static DataTableDisplayBuilder builder() {
        return new DataTableDisplayBuilder();
    }

    public static class DataTableDisplayBuilder {
        private Step step;
        private Color textColor;
        private Color backgroundColor;
        private boolean rowsCropped;
        private boolean columnsCropped;
        private boolean cellTextCropped;
        private List<Float> maximumColumnTextWidths;

        DataTableDisplayBuilder() {
        }

        public DataTableDisplayBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public DataTableDisplayBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public DataTableDisplayBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public DataTableDisplayBuilder rowsCropped(boolean rowsCropped) {
            this.rowsCropped = rowsCropped;
            return this;
        }

        public DataTableDisplayBuilder columnsCropped(boolean columnsCropped) {
            this.columnsCropped = columnsCropped;
            return this;
        }

        public DataTableDisplayBuilder cellTextCropped(boolean cellTextCropped) {
            this.cellTextCropped = cellTextCropped;
            return this;
        }

        public DataTableDisplayBuilder maximumColumnTextWidths(List<Float> maximumColumnTextWidths) {
            this.maximumColumnTextWidths = maximumColumnTextWidths;
            return this;
        }

        public DataTableDisplay build() {
            return new DataTableDisplay(this.step, this.textColor, this.backgroundColor, this.rowsCropped, this.columnsCropped, this.cellTextCropped, this.maximumColumnTextWidths);
        }

        public String toString() {
            return "DataTableDisplay.DataTableDisplayBuilder(step=" + this.step + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ", rowsCropped=" + this.rowsCropped + ", columnsCropped=" + this.columnsCropped + ", cellTextCropped=" + this.cellTextCropped + ", maximumColumnTextWidths=" + this.maximumColumnTextWidths + ")";
        }
    }
}

