/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.time.Duration;
import java.time.LocalDateTime;
import tech.grasshopper.pdf.exception.PdfReportException;

public abstract class TimeDetails {
    protected LocalDateTime startTime;
    protected LocalDateTime endTime;

    public Duration calculatedDuration() {
        return Duration.between(this.startTime, this.endTime);
    }

    public void checkTimeData() {
        if (this.startTime == null) {
            throw new PdfReportException("Start Time not present for " + this.getClass().getName() + " - " + this.getName());
        }
        if (this.endTime == null) {
            throw new PdfReportException("End Time not present for " + this.getClass().getName() + " - " + this.getName());
        }
        if (this.startTime.compareTo(this.endTime) > 0) {
            throw new PdfReportException("Start Time is later than End time for " + this.getClass().getName() + " - " + this.getName());
        }
    }

    abstract String getName();

    protected TimeDetails(TimeDetailsBuilder<?, ?> b) {
        this.startTime = ((TimeDetailsBuilder)b).startTime;
        this.endTime = ((TimeDetailsBuilder)b).endTime;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeDetails)) {
            return false;
        }
        TimeDetails other = (TimeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "TimeDetails(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    public static abstract class TimeDetailsBuilder<C extends TimeDetails, B extends TimeDetailsBuilder<C, B>> {
        private LocalDateTime startTime;
        private LocalDateTime endTime;

        protected abstract B self();

        public abstract C build();

        public B startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this.self();
        }

        public B endTime(LocalDateTime endTime) {
            this.endTime = endTime;
            return this.self();
        }

        public String toString() {
            return "TimeDetails.TimeDetailsBuilder(startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
        }
    }
}

