/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.optimizer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.PdfUtil;

public class TextLengthOptimizer {
    private PDFont font;
    private int fontsize;
    private float availableSpace;
    private int maxLines;
    private boolean textTrimmed;

    public boolean doesTextFitInSpace(String text) {
        return !(PdfUtil.getStringWidth((String)text, (PDFont)this.font, (int)this.fontsize) > this.availableSpace);
    }

    public String optimizeText(String text) {
        if (this.doesTextFitInSpace(text)) {
            return text;
        }
        this.textTrimmed = true;
        text = text.substring(0, text.length() - 2);
        while (!this.doesTextFitInSpace(new StringBuffer(text).append("*").toString())) {
            text = text.substring(0, text.length() - 1);
        }
        return String.valueOf(text) + "*";
    }

    public String optimizeTextLines(String text) {
        List lines = PdfUtil.getOptimalTextBreakLines((String)text, (PDFont)this.font, (int)this.fontsize, (float)this.availableSpace);
        if (lines.size() > this.maxLines) {
            this.textTrimmed = true;
            if (PdfUtil.getOptimalTextBreakLines((String)(String.valueOf((String)lines.get(this.maxLines - 1)) + " *"), (PDFont)this.font, (int)this.fontsize, (float)this.availableSpace).size() > 1) {
                int length = ((String)lines.get(this.maxLines - 1)).length();
                lines.set(this.maxLines - 1, String.valueOf(((String)lines.get(this.maxLines - 1)).substring(0, length - 3)) + " *");
            } else {
                lines.set(this.maxLines - 1, String.valueOf((String)lines.get(this.maxLines - 1)) + " *");
            }
        } else {
            return text;
        }
        return lines.subList(0, this.maxLines).stream().collect(Collectors.joining(" "));
    }

    public static String optimizeOutlineText(String text) {
        return TextLengthOptimizer.optimizeTextLength(text, 50);
    }

    private static String optimizeTextLength(String text, int length) {
        if (text.length() > length) {
            return String.valueOf(text.substring(0, length - 3)) + " *";
        }
        return text;
    }

    private static int $default$maxLines() {
        return 1;
    }

    private static boolean $default$textTrimmed() {
        return false;
    }

    TextLengthOptimizer(PDFont font, int fontsize, float availableSpace, int maxLines, boolean textTrimmed) {
        this.font = font;
        this.fontsize = fontsize;
        this.availableSpace = availableSpace;
        this.maxLines = maxLines;
        this.textTrimmed = textTrimmed;
    }

    public static TextLengthOptimizerBuilder builder() {
        return new TextLengthOptimizerBuilder();
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setAvailableSpace(float availableSpace) {
        this.availableSpace = availableSpace;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public boolean isTextTrimmed() {
        return this.textTrimmed;
    }

    public static class TextLengthOptimizerBuilder {
        private PDFont font;
        private int fontsize;
        private float availableSpace;
        private int maxLines;
        private boolean maxLines$set;
        private boolean textTrimmed;
        private boolean textTrimmed$set;

        TextLengthOptimizerBuilder() {
        }

        public TextLengthOptimizerBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextLengthOptimizerBuilder fontsize(int fontsize) {
            this.fontsize = fontsize;
            return this;
        }

        public TextLengthOptimizerBuilder availableSpace(float availableSpace) {
            this.availableSpace = availableSpace;
            return this;
        }

        public TextLengthOptimizerBuilder maxLines(int maxLines) {
            this.maxLines = maxLines;
            this.maxLines$set = true;
            return this;
        }

        public TextLengthOptimizerBuilder textTrimmed(boolean textTrimmed) {
            this.textTrimmed = textTrimmed;
            this.textTrimmed$set = true;
            return this;
        }

        public TextLengthOptimizer build() {
            return new TextLengthOptimizer(this.font, this.fontsize, this.availableSpace, this.maxLines$set ? this.maxLines : TextLengthOptimizer.$default$maxLines(), this.textTrimmed$set ? this.textTrimmed : TextLengthOptimizer.$default$textTrimmed());
        }

        public String toString() {
            return "TextLengthOptimizer.TextLengthOptimizerBuilder(font=" + this.font + ", fontsize=" + this.fontsize + ", availableSpace=" + this.availableSpace + ", maxLines=" + this.maxLines + ", textTrimmed=" + this.textTrimmed + ")";
        }
    }
}

