/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.destination;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;

public class Destination {
    private String name;
    private PDPage page;
    private int xCoord;
    private int yCoord;

    public PDPageXYZDestination createPDPageDestination() {
        PDPageXYZDestination destination = new PDPageXYZDestination();
        destination.setPage(this.page);
        destination.setLeft(this.xCoord);
        destination.setTop(this.yCoord);
        return destination;
    }

    private static int $default$xCoord() {
        return 0;
    }

    private static int $default$yCoord() {
        return 0;
    }

    Destination(String name, PDPage page, int xCoord, int yCoord) {
        this.name = name;
        this.page = page;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
    }

    public static DestinationBuilder builder() {
        return new DestinationBuilder();
    }

    public String getName() {
        return this.name;
    }

    public PDPage getPage() {
        return this.page;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getYCoord() {
        return this.yCoord;
    }

    public static class DestinationBuilder {
        private String name;
        private PDPage page;
        private int xCoord;
        private boolean xCoord$set;
        private int yCoord;
        private boolean yCoord$set;

        DestinationBuilder() {
        }

        public DestinationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DestinationBuilder page(PDPage page) {
            this.page = page;
            return this;
        }

        public DestinationBuilder xCoord(int xCoord) {
            this.xCoord = xCoord;
            this.xCoord$set = true;
            return this;
        }

        public DestinationBuilder yCoord(int yCoord) {
            this.yCoord = yCoord;
            this.yCoord$set = true;
            return this;
        }

        public Destination build() {
            return new Destination(this.name, this.page, this.xCoord$set ? this.xCoord : Destination.$default$xCoord(), this.yCoord$set ? this.yCoord : Destination.$default$yCoord());
        }

        public String toString() {
            return "Destination.DestinationBuilder(name=" + this.name + ", page=" + this.page + ", xCoord=" + this.xCoord + ", yCoord=" + this.yCoord + ")";
        }
    }

    public static class DestinationStore {
        private Destination dashboardDestination;
        private List<Destination> featuresDestinations = new ArrayList<Destination>();
        private List<Destination> scenariosDestinations = new ArrayList<Destination>();

        public void addFeatureDestination(Destination destination) {
            this.featuresDestinations.add(destination);
        }

        public void addScenarioDestination(Destination destination) {
            this.scenariosDestinations.add(destination);
        }

        public Destination getDashboardDestination() {
            return this.dashboardDestination;
        }

        public List<Destination> getFeaturesDestinations() {
            return this.featuresDestinations;
        }

        public List<Destination> getScenariosDestinations() {
            return this.scenariosDestinations;
        }

        public void setDashboardDestination(Destination dashboardDestination) {
            this.dashboardDestination = dashboardDestination;
        }

        public void setFeaturesDestinations(List<Destination> featuresDestinations) {
            this.featuresDestinations = featuresDestinations;
        }

        public void setScenariosDestinations(List<Destination> scenariosDestinations) {
            this.scenariosDestinations = scenariosDestinations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DestinationStore)) {
                return false;
            }
            DestinationStore other = (DestinationStore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Destination this$dashboardDestination = this.getDashboardDestination();
            Destination other$dashboardDestination = other.getDashboardDestination();
            if (this$dashboardDestination == null ? other$dashboardDestination != null : !this$dashboardDestination.equals(other$dashboardDestination)) {
                return false;
            }
            List<Destination> this$featuresDestinations = this.getFeaturesDestinations();
            List<Destination> other$featuresDestinations = other.getFeaturesDestinations();
            if (this$featuresDestinations == null ? other$featuresDestinations != null : !((Object)this$featuresDestinations).equals(other$featuresDestinations)) {
                return false;
            }
            List<Destination> this$scenariosDestinations = this.getScenariosDestinations();
            List<Destination> other$scenariosDestinations = other.getScenariosDestinations();
            return !(this$scenariosDestinations == null ? other$scenariosDestinations != null : !((Object)this$scenariosDestinations).equals(other$scenariosDestinations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DestinationStore;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Destination $dashboardDestination = this.getDashboardDestination();
            result = result * 59 + ($dashboardDestination == null ? 43 : $dashboardDestination.hashCode());
            List<Destination> $featuresDestinations = this.getFeaturesDestinations();
            result = result * 59 + ($featuresDestinations == null ? 43 : ((Object)$featuresDestinations).hashCode());
            List<Destination> $scenariosDestinations = this.getScenariosDestinations();
            result = result * 59 + ($scenariosDestinations == null ? 43 : ((Object)$scenariosDestinations).hashCode());
            return result;
        }

        public String toString() {
            return "Destination.DestinationStore(dashboardDestination=" + this.getDashboardDestination() + ", featuresDestinations=" + this.getFeaturesDestinations() + ", scenariosDestinations=" + this.getScenariosDestinations() + ")";
        }
    }
}

