/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config;

import java.awt.Color;
import tech.grasshopper.pdf.config.DetailedConfig;
import tech.grasshopper.pdf.config.SummaryConfig;

public class ReportConfig {
    private String passColor;
    private String failColor;
    private String skipColor;
    private boolean displayFeature = true;
    private boolean displayScenario = true;
    private boolean displayDetailed = true;
    private SummaryConfig summaryConfig = new SummaryConfig();
    private FeatureConfig featureConfig = new FeatureConfig();
    private ScenarioConfig scenarioConfig = new ScenarioConfig();
    private DetailedConfig.DetailedFeatureConfig detailedFeatureConfig = new DetailedConfig.DetailedFeatureConfig();
    private DetailedConfig.DetailedScenarioConfig detailedScenarioConfig = new DetailedConfig.DetailedScenarioConfig();
    private DetailedConfig.DetailedStepHookConfig detailedStepHookConfig = new DetailedConfig.DetailedStepHookConfig();

    public Color passedColor() {
        return ReportConfig.createColor(this.passColor, Color.GREEN);
    }

    public Color failedColor() {
        return ReportConfig.createColor(this.failColor, Color.RED);
    }

    public Color skippedColor() {
        return ReportConfig.createColor(this.skipColor, Color.ORANGE);
    }

    static Color createColor(String hexCode, Color defaultColor) {
        try {
            return Color.decode("#" + hexCode);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    static int createCount(String itemCount, int defaultCount) {
        int count = 0;
        try {
            count = Integer.parseInt(itemCount);
            if (count > defaultCount) {
                return defaultCount;
            }
        }
        catch (NumberFormatException e) {
            return defaultCount;
        }
        return count;
    }

    public String getPassColor() {
        return this.passColor;
    }

    public String getFailColor() {
        return this.failColor;
    }

    public String getSkipColor() {
        return this.skipColor;
    }

    public boolean isDisplayFeature() {
        return this.displayFeature;
    }

    public boolean isDisplayScenario() {
        return this.displayScenario;
    }

    public boolean isDisplayDetailed() {
        return this.displayDetailed;
    }

    public SummaryConfig getSummaryConfig() {
        return this.summaryConfig;
    }

    public FeatureConfig getFeatureConfig() {
        return this.featureConfig;
    }

    public ScenarioConfig getScenarioConfig() {
        return this.scenarioConfig;
    }

    public DetailedConfig.DetailedFeatureConfig getDetailedFeatureConfig() {
        return this.detailedFeatureConfig;
    }

    public DetailedConfig.DetailedScenarioConfig getDetailedScenarioConfig() {
        return this.detailedScenarioConfig;
    }

    public DetailedConfig.DetailedStepHookConfig getDetailedStepHookConfig() {
        return this.detailedStepHookConfig;
    }

    public void setPassColor(String passColor) {
        this.passColor = passColor;
    }

    public void setFailColor(String failColor) {
        this.failColor = failColor;
    }

    public void setSkipColor(String skipColor) {
        this.skipColor = skipColor;
    }

    public void setDisplayFeature(boolean displayFeature) {
        this.displayFeature = displayFeature;
    }

    public void setDisplayScenario(boolean displayScenario) {
        this.displayScenario = displayScenario;
    }

    public void setDisplayDetailed(boolean displayDetailed) {
        this.displayDetailed = displayDetailed;
    }

    public void setSummaryConfig(SummaryConfig summaryConfig) {
        this.summaryConfig = summaryConfig;
    }

    public void setFeatureConfig(FeatureConfig featureConfig) {
        this.featureConfig = featureConfig;
    }

    public void setScenarioConfig(ScenarioConfig scenarioConfig) {
        this.scenarioConfig = scenarioConfig;
    }

    public void setDetailedFeatureConfig(DetailedConfig.DetailedFeatureConfig detailedFeatureConfig) {
        this.detailedFeatureConfig = detailedFeatureConfig;
    }

    public void setDetailedScenarioConfig(DetailedConfig.DetailedScenarioConfig detailedScenarioConfig) {
        this.detailedScenarioConfig = detailedScenarioConfig;
    }

    public void setDetailedStepHookConfig(DetailedConfig.DetailedStepHookConfig detailedStepHookConfig) {
        this.detailedStepHookConfig = detailedStepHookConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportConfig)) {
            return false;
        }
        ReportConfig other = (ReportConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$passColor = this.getPassColor();
        String other$passColor = other.getPassColor();
        if (this$passColor == null ? other$passColor != null : !this$passColor.equals(other$passColor)) {
            return false;
        }
        String this$failColor = this.getFailColor();
        String other$failColor = other.getFailColor();
        if (this$failColor == null ? other$failColor != null : !this$failColor.equals(other$failColor)) {
            return false;
        }
        String this$skipColor = this.getSkipColor();
        String other$skipColor = other.getSkipColor();
        if (this$skipColor == null ? other$skipColor != null : !this$skipColor.equals(other$skipColor)) {
            return false;
        }
        if (this.isDisplayFeature() != other.isDisplayFeature()) {
            return false;
        }
        if (this.isDisplayScenario() != other.isDisplayScenario()) {
            return false;
        }
        if (this.isDisplayDetailed() != other.isDisplayDetailed()) {
            return false;
        }
        SummaryConfig this$summaryConfig = this.getSummaryConfig();
        SummaryConfig other$summaryConfig = other.getSummaryConfig();
        if (this$summaryConfig == null ? other$summaryConfig != null : !((Object)this$summaryConfig).equals(other$summaryConfig)) {
            return false;
        }
        FeatureConfig this$featureConfig = this.getFeatureConfig();
        FeatureConfig other$featureConfig = other.getFeatureConfig();
        if (this$featureConfig == null ? other$featureConfig != null : !((Object)this$featureConfig).equals(other$featureConfig)) {
            return false;
        }
        ScenarioConfig this$scenarioConfig = this.getScenarioConfig();
        ScenarioConfig other$scenarioConfig = other.getScenarioConfig();
        if (this$scenarioConfig == null ? other$scenarioConfig != null : !((Object)this$scenarioConfig).equals(other$scenarioConfig)) {
            return false;
        }
        DetailedConfig.DetailedFeatureConfig this$detailedFeatureConfig = this.getDetailedFeatureConfig();
        DetailedConfig.DetailedFeatureConfig other$detailedFeatureConfig = other.getDetailedFeatureConfig();
        if (this$detailedFeatureConfig == null ? other$detailedFeatureConfig != null : !((Object)this$detailedFeatureConfig).equals(other$detailedFeatureConfig)) {
            return false;
        }
        DetailedConfig.DetailedScenarioConfig this$detailedScenarioConfig = this.getDetailedScenarioConfig();
        DetailedConfig.DetailedScenarioConfig other$detailedScenarioConfig = other.getDetailedScenarioConfig();
        if (this$detailedScenarioConfig == null ? other$detailedScenarioConfig != null : !((Object)this$detailedScenarioConfig).equals(other$detailedScenarioConfig)) {
            return false;
        }
        DetailedConfig.DetailedStepHookConfig this$detailedStepHookConfig = this.getDetailedStepHookConfig();
        DetailedConfig.DetailedStepHookConfig other$detailedStepHookConfig = other.getDetailedStepHookConfig();
        return !(this$detailedStepHookConfig == null ? other$detailedStepHookConfig != null : !((Object)this$detailedStepHookConfig).equals(other$detailedStepHookConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $passColor = this.getPassColor();
        result = result * 59 + ($passColor == null ? 43 : $passColor.hashCode());
        String $failColor = this.getFailColor();
        result = result * 59 + ($failColor == null ? 43 : $failColor.hashCode());
        String $skipColor = this.getSkipColor();
        result = result * 59 + ($skipColor == null ? 43 : $skipColor.hashCode());
        result = result * 59 + (this.isDisplayFeature() ? 79 : 97);
        result = result * 59 + (this.isDisplayScenario() ? 79 : 97);
        result = result * 59 + (this.isDisplayDetailed() ? 79 : 97);
        SummaryConfig $summaryConfig = this.getSummaryConfig();
        result = result * 59 + ($summaryConfig == null ? 43 : ((Object)$summaryConfig).hashCode());
        FeatureConfig $featureConfig = this.getFeatureConfig();
        result = result * 59 + ($featureConfig == null ? 43 : ((Object)$featureConfig).hashCode());
        ScenarioConfig $scenarioConfig = this.getScenarioConfig();
        result = result * 59 + ($scenarioConfig == null ? 43 : ((Object)$scenarioConfig).hashCode());
        DetailedConfig.DetailedFeatureConfig $detailedFeatureConfig = this.getDetailedFeatureConfig();
        result = result * 59 + ($detailedFeatureConfig == null ? 43 : ((Object)$detailedFeatureConfig).hashCode());
        DetailedConfig.DetailedScenarioConfig $detailedScenarioConfig = this.getDetailedScenarioConfig();
        result = result * 59 + ($detailedScenarioConfig == null ? 43 : ((Object)$detailedScenarioConfig).hashCode());
        DetailedConfig.DetailedStepHookConfig $detailedStepHookConfig = this.getDetailedStepHookConfig();
        result = result * 59 + ($detailedStepHookConfig == null ? 43 : ((Object)$detailedStepHookConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ReportConfig(passColor=" + this.getPassColor() + ", failColor=" + this.getFailColor() + ", skipColor=" + this.getSkipColor() + ", displayFeature=" + this.isDisplayFeature() + ", displayScenario=" + this.isDisplayScenario() + ", displayDetailed=" + this.isDisplayDetailed() + ", summaryConfig=" + this.getSummaryConfig() + ", featureConfig=" + this.getFeatureConfig() + ", scenarioConfig=" + this.getScenarioConfig() + ", detailedFeatureConfig=" + this.getDetailedFeatureConfig() + ", detailedScenarioConfig=" + this.getDetailedScenarioConfig() + ", detailedStepHookConfig=" + this.getDetailedStepHookConfig() + ")";
    }

    public static class FeatureConfig {
        private String featureCount;
        private String totalColor;
        private String durationColor;
        private final int defaultCount = 10;

        public int featureCount() {
            return ReportConfig.createCount(this.featureCount, 10);
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public Color durationColor() {
            return ReportConfig.createColor(this.durationColor, Color.BLACK);
        }

        public String getFeatureCount() {
            return this.featureCount;
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public String getDurationColor() {
            return this.durationColor;
        }

        public int getDefaultCount() {
            return 10;
        }

        public void setFeatureCount(String featureCount) {
            this.featureCount = featureCount;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public void setDurationColor(String durationColor) {
            this.durationColor = durationColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig other = (FeatureConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$featureCount = this.getFeatureCount();
            String other$featureCount = other.getFeatureCount();
            if (this$featureCount == null ? other$featureCount != null : !this$featureCount.equals(other$featureCount)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            if (this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor)) {
                return false;
            }
            String this$durationColor = this.getDurationColor();
            String other$durationColor = other.getDurationColor();
            if (this$durationColor == null ? other$durationColor != null : !this$durationColor.equals(other$durationColor)) {
                return false;
            }
            return this.getDefaultCount() == other.getDefaultCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeatureConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $featureCount = this.getFeatureCount();
            result = result * 59 + ($featureCount == null ? 43 : $featureCount.hashCode());
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            String $durationColor = this.getDurationColor();
            result = result * 59 + ($durationColor == null ? 43 : $durationColor.hashCode());
            result = result * 59 + this.getDefaultCount();
            return result;
        }

        public String toString() {
            return "ReportConfig.FeatureConfig(featureCount=" + this.getFeatureCount() + ", totalColor=" + this.getTotalColor() + ", durationColor=" + this.getDurationColor() + ", defaultCount=" + this.getDefaultCount() + ")";
        }
    }

    public static class ScenarioConfig {
        private String scenarioCount;
        private String totalColor;
        private String durationColor;
        private final int defaultCount = 10;

        public int scenarioCount() {
            return ReportConfig.createCount(this.scenarioCount, 10);
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public Color durationColor() {
            return ReportConfig.createColor(this.durationColor, Color.BLACK);
        }

        public String getScenarioCount() {
            return this.scenarioCount;
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public String getDurationColor() {
            return this.durationColor;
        }

        public int getDefaultCount() {
            return 10;
        }

        public void setScenarioCount(String scenarioCount) {
            this.scenarioCount = scenarioCount;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public void setDurationColor(String durationColor) {
            this.durationColor = durationColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScenarioConfig)) {
                return false;
            }
            ScenarioConfig other = (ScenarioConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scenarioCount = this.getScenarioCount();
            String other$scenarioCount = other.getScenarioCount();
            if (this$scenarioCount == null ? other$scenarioCount != null : !this$scenarioCount.equals(other$scenarioCount)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            if (this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor)) {
                return false;
            }
            String this$durationColor = this.getDurationColor();
            String other$durationColor = other.getDurationColor();
            if (this$durationColor == null ? other$durationColor != null : !this$durationColor.equals(other$durationColor)) {
                return false;
            }
            return this.getDefaultCount() == other.getDefaultCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScenarioConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scenarioCount = this.getScenarioCount();
            result = result * 59 + ($scenarioCount == null ? 43 : $scenarioCount.hashCode());
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            String $durationColor = this.getDurationColor();
            result = result * 59 + ($durationColor == null ? 43 : $durationColor.hashCode());
            result = result * 59 + this.getDefaultCount();
            return result;
        }

        public String toString() {
            return "ReportConfig.ScenarioConfig(scenarioCount=" + this.getScenarioCount() + ", totalColor=" + this.getTotalColor() + ", durationColor=" + this.getDurationColor() + ", defaultCount=" + this.getDefaultCount() + ")";
        }
    }
}

