/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.outline.Outline;
import tech.grasshopper.pdf.section.dashboard.Dashboard;
import tech.grasshopper.pdf.section.details.DetailedSection;
import tech.grasshopper.pdf.section.feature.FeatureSection;
import tech.grasshopper.pdf.section.scenario.ScenarioSection;

public class PDFCucumberReport {
    private static final Logger logger = Logger.getLogger(PDFCucumberReport.class.getName());
    private ReportData reportData;
    private File reportFile;
    private PDDocument document;
    private Destination.DestinationStore destinations;
    private ReportConfig reportConfig;

    public PDFCucumberReport(ReportData reportData, String reportDirectory) {
        this(reportData, new File(String.valueOf(reportDirectory) + "/report.pdf"));
    }

    public PDFCucumberReport(ReportData reportData, File reportFile) {
        this.reportData = reportData;
        this.reportFile = reportFile;
        this.document = new PDDocument();
        this.destinations = new Destination.DestinationStore();
        ReportFont.loadReportFontFamily(this.document);
        this.createReportDirectory(this.reportFile.getParent());
        this.collectReportConfiguration();
        reportData.populateSectionData();
    }

    private void createReportDirectory(String reportDirectory) {
        File dir = new File(reportDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private void collectReportConfiguration() {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ReportConfig.class));
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream("src/test/resources/pdf-config.yaml");
            this.reportConfig = (ReportConfig)yaml.load((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.INFO, "PDF report configuration YAML file not found. Using default settings.");
            this.reportConfig = new ReportConfig();
        }
    }

    public void createReport() {
        ((Dashboard)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)Dashboard.builder().displayData(this.reportData.getSummaryData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
        if (this.reportConfig.isDisplayFeature()) {
            ((FeatureSection)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)FeatureSection.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
        }
        if (this.reportConfig.isDisplayScenario()) {
            ((ScenarioSection)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)ScenarioSection.builder().displayData(this.reportData.getScenarioData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
        }
        if (this.reportConfig.isDisplayDetailed()) {
            ((DetailedSection)((DetailedSection.DetailedSectionBuilder)((DetailedSection.DetailedSectionBuilder)((DetailedSection.DetailedSectionBuilder)DetailedSection.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).build()).createSection();
        }
        Annotation.updateDestination(this.reportData);
        Outline.createDocumentOutline(this.document, this.reportConfig, this.destinations, this.reportData);
        try {
            this.document.save(this.reportFile);
            this.document.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }
}

