/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import tech.deepdreams.worker.api.dtos.BenefitItemDTO;
import tech.deepdreams.worker.api.dtos.ConstantValueDTO;
import tech.deepdreams.worker.api.dtos.DeductionItemDTO;
import tech.deepdreams.worker.api.dtos.EmployeeDTO;
import tech.deepdreams.worker.api.dtos.PayPeriodDTO;
import tech.deepdreams.worker.api.dtos.PayslipDTO;
import tech.deepdreams.worker.api.dtos.ReportDTO;
import tech.deepdreams.worker.api.dtos.SubscriberDTO;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.enums.FormatType;
import tech.deepdreams.worker.api.services.PayslipGeneratorService;
import tech.deepdreams.worker.services.report.HeaderFooterPageEvent;

public class PayslipPdfGeneratorServiceImpl
implements PayslipGeneratorService {
    private static final Logger log = Logger.getLogger(PayslipPdfGeneratorServiceImpl.class);
    private DecimalFormat percentFormatter = new DecimalFormat("#0.00");
    private DecimalFormat amountFormatter = new DecimalFormat("##,###");

    @Override
    public String getPayslipType() {
        return "BULLETIN_DE_PAIE";
    }

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public FormatType getFormatType() {
        return FormatType.PDF;
    }

    @Override
    public ReportDTO generate(SubscriberDTO subscriber, EmployeeDTO employee, PayPeriodDTO payPeriod, PayslipDTO payslip) {
        try {
            String fs = System.getProperty("file.separator");
            String folderName = System.getProperty("user.home");
            String fileName = "bulletin_" + payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + employee.getFirstName() + "_" + employee.getLastName() + ".pdf";
            log.info("Fichier cible = " + new File(fileName).getAbsolutePath());
            ReportDTO reportDTO = new ReportDTO();
            reportDTO.setFileName(fileName);
            reportDTO.setDocumentType("PDF");
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(folderName + fs + fileName));
            HeaderFooterPageEvent event = new HeaderFooterPageEvent();
            writer.setPageEvent(event);
            document.open();
            PdfPTable titleTable = new PdfPTable(1);
            titleTable.setHorizontalAlignment(1);
            titleTable.setSpacingBefore(50.0f);
            Phrase titlePhrase = new Phrase("BULLETIN DE PAIE", new Font(Font.FontFamily.TIMES_ROMAN, 18.0f, 1));
            PdfPCell titleCell = new PdfPCell(titlePhrase);
            titleCell.setBorder(0);
            titleCell.setHorizontalAlignment(1);
            titleTable.addCell(titleCell);
            PdfPCell subTitle1Cell = new PdfPCell(new Phrase(payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " - " + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 0)));
            subTitle1Cell.setHorizontalAlignment(1);
            subTitle1Cell.setBorder(0);
            titleTable.addCell(subTitle1Cell);
            document.add(titleTable);
            PdfPTable headerTable = new PdfPTable(4);
            headerTable.setHorizontalAlignment(1);
            headerTable.setSpacingBefore(30.0f);
            headerTable.setWidthPercentage(100.0f);
            Phrase employerLabelPhrase = new Phrase("Employeur", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell employerLabelCell = new PdfPCell(employerLabelPhrase);
            employerLabelCell.setColspan(2);
            employerLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            employerLabelCell.setHorizontalAlignment(1);
            headerTable.addCell(employerLabelCell);
            Phrase employeeLabelPhrase = new Phrase("Salari\u00e9", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell employeeLabelCell = new PdfPCell(employeeLabelPhrase);
            employeeLabelCell.setColspan(2);
            employeeLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            employeeLabelCell.setHorizontalAlignment(1);
            headerTable.addCell(employeeLabelCell);
            Phrase labelLabelPhrase = new Phrase("Nom", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell labelLabelCell = new PdfPCell(labelLabelPhrase);
            labelLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            labelLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelLabelCell);
            Phrase labelPhrase = new Phrase(subscriber.getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell labelCell = new PdfPCell(labelPhrase);
            labelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelCell);
            Phrase regNumberLabelPhrase = new Phrase("Matricule", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell regNumberLabelCell = new PdfPCell(regNumberLabelPhrase);
            regNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            regNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(regNumberLabelCell);
            Phrase regNumberPhrase = new Phrase(employee.getRegistrationNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell regNumberCell = new PdfPCell(regNumberPhrase);
            regNumberCell.setHorizontalAlignment(0);
            headerTable.addCell(regNumberCell);
            Phrase taxNumberLabelPhrase = new Phrase("Num\u00e9ro de contribuable", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell taxNumberLabelCell = new PdfPCell(taxNumberLabelPhrase);
            taxNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            taxNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(taxNumberLabelCell);
            Phrase taxNumberPhrase = new Phrase(subscriber.getTaxPayerNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell taxNumberCell = new PdfPCell(taxNumberPhrase);
            taxNumberCell.setHorizontalAlignment(0);
            headerTable.addCell(taxNumberCell);
            Phrase nameLabelPhrase = new Phrase("Nom et Pr\u00e9nom", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell nameLabelCell = new PdfPCell(nameLabelPhrase);
            nameLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            nameLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(nameLabelCell);
            Phrase namePhrase = new Phrase(employee.getLastName() + " " + employee.getFirstName(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell nameCell = new PdfPCell(namePhrase);
            nameCell.setHorizontalAlignment(0);
            headerTable.addCell(nameCell);
            Phrase secNumberLabelPhrase = new Phrase("Num\u00e9ro CNPS", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell secNumberLabelCell = new PdfPCell(secNumberLabelPhrase);
            secNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            secNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(secNumberLabelCell);
            Phrase secNumberPhrase = new Phrase(subscriber.getSocialRegistrationNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell secNumberCell = new PdfPCell(secNumberPhrase);
            secNumberCell.setHorizontalAlignment(0);
            headerTable.addCell(secNumberCell);
            PdfPCell nasLabelCell = new PdfPCell(new Phrase("Num\u00e9ro CNPS", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            nasLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            nasLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(nasLabelCell);
            PdfPCell nasCell = new PdfPCell(new Phrase(employee.getSocialSecurityNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            nasCell.setHorizontalAlignment(0);
            headerTable.addCell(nasCell);
            Phrase branchLabelPhrase = new Phrase("Secteur d'activit\u00e9", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell branchLabelCell = new PdfPCell(branchLabelPhrase);
            branchLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            branchLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(branchLabelCell);
            Phrase branchPhrase = new Phrase(subscriber.getBranch() == null ? "" : subscriber.getBranch().getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell branchCell = new PdfPCell(branchPhrase);
            branchCell.setHorizontalAlignment(0);
            headerTable.addCell(branchCell);
            PdfPCell functionLabelCell = new PdfPCell(new Phrase("Fonction", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            functionLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            functionLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(functionLabelCell);
            PdfPCell functionCell = new PdfPCell(new Phrase(employee.getFunction() == null ? "" : employee.getFunction().getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            functionCell.setHorizontalAlignment(0);
            headerTable.addCell(functionCell);
            Phrase headquartersLabelPhrase = new Phrase("Si\u00e8ge social", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell headquartersLabelCell = new PdfPCell(headquartersLabelPhrase);
            headquartersLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            headquartersLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(headquartersLabelCell);
            Phrase headquartersPhrase = new Phrase((subscriber.getLocality() == null ? "" : subscriber.getLocality().getLabel()) + ", " + (subscriber.getCountry() == null ? "" : subscriber.getCountry().getLabel()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell headquartersCell = new PdfPCell(headquartersPhrase);
            headquartersCell.setHorizontalAlignment(0);
            headerTable.addCell(headquartersCell);
            PdfPCell seniorityLabelCell = new PdfPCell(new Phrase("Anciennet\u00e9", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            seniorityLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            seniorityLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(seniorityLabelCell);
            PdfPCell seniorityCell = new PdfPCell(new Phrase((String)(employee.getStartDate() == null ? "" : Period.between(employee.getStartDate(), payPeriod.getEndDate()).getYears() + " ann\u00e9e(s)"), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            seniorityCell.setHorizontalAlignment(0);
            headerTable.addCell(seniorityCell);
            document.add(headerTable);
            PdfPTable bodyTable = new PdfPTable(7);
            bodyTable.setSpacingBefore(20.0f);
            bodyTable.setHorizontalAlignment(1);
            bodyTable.setWidthPercentage(100.0f);
            bodyTable.setWidths(new float[]{10.0f, 40.0f, 20.0f, 10.0f, 20.0f, 10.0f, 20.0f});
            PdfPCell codeLabCell = new PdfPCell(new Phrase("Code", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            codeLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            codeLabCell.setHorizontalAlignment(1);
            codeLabCell.setVerticalAlignment(5);
            codeLabCell.setRowspan(2);
            bodyTable.addCell(codeLabCell);
            PdfPCell rubriqueLabCell = new PdfPCell(new Phrase("Libell\u00e9", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            rubriqueLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            rubriqueLabCell.setHorizontalAlignment(1);
            rubriqueLabCell.setVerticalAlignment(5);
            rubriqueLabCell.setRowspan(2);
            bodyTable.addCell(rubriqueLabCell);
            PdfPCell baseLabCell = new PdfPCell(new Phrase("Base", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            baseLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            baseLabCell.setHorizontalAlignment(1);
            baseLabCell.setVerticalAlignment(5);
            baseLabCell.setRowspan(2);
            bodyTable.addCell(baseLabCell);
            PdfPCell partSalLabCell = new PdfPCell(new Phrase("Part Salariale", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            partSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            partSalLabCell.setHorizontalAlignment(1);
            partSalLabCell.setVerticalAlignment(5);
            partSalLabCell.setColspan(2);
            bodyTable.addCell(partSalLabCell);
            PdfPCell partPatLabCell = new PdfPCell(new Phrase("Part Patronale", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            partPatLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            partPatLabCell.setHorizontalAlignment(1);
            partPatLabCell.setVerticalAlignment(5);
            partPatLabCell.setColspan(2);
            bodyTable.addCell(partPatLabCell);
            PdfPCell tauxSalLabCell = new PdfPCell(new Phrase("Taux", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            tauxSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            tauxSalLabCell.setHorizontalAlignment(1);
            tauxSalLabCell.setVerticalAlignment(5);
            bodyTable.addCell(tauxSalLabCell);
            PdfPCell montantSalLabCell = new PdfPCell(new Phrase("Montant", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            montantSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            montantSalLabCell.setHorizontalAlignment(1);
            montantSalLabCell.setVerticalAlignment(5);
            bodyTable.addCell(montantSalLabCell);
            PdfPCell tauxPatLabCell = new PdfPCell(new Phrase("Taux", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            tauxPatLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            tauxPatLabCell.setHorizontalAlignment(1);
            tauxPatLabCell.setVerticalAlignment(5);
            bodyTable.addCell(tauxPatLabCell);
            PdfPCell montantPatLabCell = new PdfPCell(new Phrase("Montant", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            montantPatLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            montantPatLabCell.setHorizontalAlignment(1);
            montantPatLabCell.setVerticalAlignment(5);
            bodyTable.addCell(montantPatLabCell);
            for (BenefitItemDTO item : payslip.getBenefitItems()) {
                PdfPCell _codeCell = new PdfPCell(new Phrase(item.getElement().getCode(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _codeCell.setHorizontalAlignment(1);
                bodyTable.addCell(_codeCell);
                PdfPCell _rubriqueCell = new PdfPCell(new Phrase(item.getElement().getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _rubriqueCell.setHorizontalAlignment(0);
                bodyTable.addCell(_rubriqueCell);
                PdfPCell _baseCell = new PdfPCell(new Phrase("", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _baseCell.setHorizontalAlignment(2);
                bodyTable.addCell(_baseCell);
                PdfPCell _rateSalCell = new PdfPCell(new Phrase("", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _rateSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_rateSalCell);
                PdfPCell _amountSalCell = new PdfPCell(new Phrase(item.getAmount() == null ? "" : this.amountFormatter.format(item.getAmount().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _amountSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_amountSalCell);
                PdfPCell _ratePatCell = new PdfPCell(new Phrase("", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _ratePatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_ratePatCell);
                PdfPCell _amountPatCell = new PdfPCell(new Phrase("", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _amountPatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_amountPatCell);
            }
            PdfPCell grossSalLabCell = new PdfPCell(new Phrase("Salaire brut", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            grossSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            grossSalLabCell.setHorizontalAlignment(0);
            grossSalLabCell.setVerticalAlignment(5);
            grossSalLabCell.setColspan(3);
            bodyTable.addCell(grossSalLabCell);
            PdfPCell grossSalValCell = new PdfPCell(new Phrase(this.amountFormatter.format(payslip.getGrossSalary()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            grossSalValCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            grossSalValCell.setHorizontalAlignment(2);
            grossSalValCell.setVerticalAlignment(5);
            grossSalValCell.setColspan(4);
            bodyTable.addCell(grossSalValCell);
            for (DeductionItemDTO item : payslip.getDeductionItems()) {
                PdfPCell _codeCell = new PdfPCell(new Phrase(item.getElement().getCode(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _codeCell.setHorizontalAlignment(1);
                bodyTable.addCell(_codeCell);
                PdfPCell _rubriqueCell = new PdfPCell(new Phrase(item.getElement().getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _rubriqueCell.setHorizontalAlignment(0);
                bodyTable.addCell(_rubriqueCell);
                PdfPCell _baseCell = new PdfPCell(new Phrase(item.getBasisAmount() == null ? "" : this.amountFormatter.format(item.getBasisAmount().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _baseCell.setHorizontalAlignment(2);
                bodyTable.addCell(_baseCell);
                PdfPCell _rateSalCell = new PdfPCell(new Phrase(item.getEmployeeRate() == null ? "" : this.percentFormatter.format(item.getEmployeeRate().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _rateSalCell.setHorizontalAlignment(1);
                bodyTable.addCell(_rateSalCell);
                PdfPCell _amountSalCell = new PdfPCell(new Phrase(item.getEmployeeAmount() == null ? "" : this.amountFormatter.format(item.getEmployeeAmount().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _amountSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_amountSalCell);
                PdfPCell _ratePatCell = new PdfPCell(new Phrase(item.getEmployerRate() == null ? "" : this.percentFormatter.format(item.getEmployerRate().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _ratePatCell.setHorizontalAlignment(1);
                bodyTable.addCell(_ratePatCell);
                PdfPCell _amountPatCell = new PdfPCell(new Phrase(item.getEmployerAmount() == null ? "" : this.amountFormatter.format(item.getEmployerAmount().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _amountPatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_amountPatCell);
            }
            PdfPCell totalLabCell = new PdfPCell(new Phrase("Total des charges", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            totalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            totalLabCell.setHorizontalAlignment(0);
            totalLabCell.setVerticalAlignment(5);
            totalLabCell.setColspan(3);
            bodyTable.addCell(totalLabCell);
            PdfPCell chargesSalValCell = new PdfPCell(new Phrase(this.amountFormatter.format(payslip.getEmployeeDeductions()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            chargesSalValCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            chargesSalValCell.setHorizontalAlignment(2);
            chargesSalValCell.setVerticalAlignment(5);
            chargesSalValCell.setColspan(2);
            bodyTable.addCell(chargesSalValCell);
            PdfPCell chargesPatValCell = new PdfPCell(new Phrase(this.amountFormatter.format(payslip.getEmployerDeductions()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            chargesPatValCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            chargesPatValCell.setHorizontalAlignment(2);
            chargesPatValCell.setVerticalAlignment(5);
            chargesPatValCell.setColspan(2);
            bodyTable.addCell(chargesPatValCell);
            document.add(bodyTable);
            PdfPTable footerTable = new PdfPTable(6);
            footerTable.setSpacingBefore(10.0f);
            footerTable.setHorizontalAlignment(1);
            footerTable.setWidthPercentage(100.0f);
            footerTable.setWidths(new int[]{25, 25, 25, 25, 25, 25});
            PdfPCell workingHoursLabelCell = new PdfPCell(new Phrase("Heures travaill\u00e9es", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            workingHoursLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            workingHoursLabelCell.setHorizontalAlignment(1);
            workingHoursLabelCell.setRowspan(2);
            footerTable.addCell(workingHoursLabelCell);
            PdfPCell absencesHoursLabelCell = new PdfPCell(new Phrase("Heures d'absences", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            absencesHoursLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            absencesHoursLabelCell.setHorizontalAlignment(1);
            absencesHoursLabelCell.setRowspan(2);
            footerTable.addCell(absencesHoursLabelCell);
            PdfPCell overtimeHoursLabelCell = new PdfPCell(new Phrase("Heures suppl\u00e9mentaires", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            overtimeHoursLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            overtimeHoursLabelCell.setHorizontalAlignment(1);
            overtimeHoursLabelCell.setColspan(4);
            footerTable.addCell(overtimeHoursLabelCell);
            PdfPCell overtimeHours20LabelCell = new PdfPCell(new Phrase("20%", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            overtimeHours20LabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            overtimeHours20LabelCell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours20LabelCell);
            PdfPCell overtimeHours30LabelCell = new PdfPCell(new Phrase("30%", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            overtimeHours30LabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            overtimeHours30LabelCell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours30LabelCell);
            PdfPCell overtimeHours40LabelCell = new PdfPCell(new Phrase("40%", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            overtimeHours40LabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            overtimeHours40LabelCell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours40LabelCell);
            PdfPCell overtimeHours50LabelCell = new PdfPCell(new Phrase("50%", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            overtimeHours50LabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            overtimeHours50LabelCell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours50LabelCell);
            ConstantValueDTO workingHoursVal = payslip.getConstantValues().stream().filter(value -> "106".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell workingHoursCell = new PdfPCell(new Phrase(this.amountFormatter.format(workingHoursVal.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            workingHoursCell.setHorizontalAlignment(1);
            footerTable.addCell(workingHoursCell);
            ConstantValueDTO absencesVal = payslip.getConstantValues().stream().filter(value -> "120".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell absencesCell = new PdfPCell(new Phrase(this.amountFormatter.format(absencesVal.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            absencesCell.setHorizontalAlignment(1);
            footerTable.addCell(absencesCell);
            ConstantValueDTO overtimeHours20Val = payslip.getConstantValues().stream().filter(value -> "110".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell overtimeHours20Cell = new PdfPCell(new Phrase(this.amountFormatter.format(overtimeHours20Val.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            overtimeHours20Cell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours20Cell);
            ConstantValueDTO overtimeHours30Val = payslip.getConstantValues().stream().filter(value -> "111".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell overtimeHours30Cell = new PdfPCell(new Phrase(this.amountFormatter.format(overtimeHours30Val.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            overtimeHours30Cell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours30Cell);
            ConstantValueDTO overtimeHours40Val = payslip.getConstantValues().stream().filter(value -> "112".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell overtimeHours40Cell = new PdfPCell(new Phrase(this.amountFormatter.format(overtimeHours40Val.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            overtimeHours40Cell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours40Cell);
            ConstantValueDTO overtimeHours50Val = payslip.getConstantValues().stream().filter(value -> "113".equals(value.getConstant().getCode())).findAny().orElseThrow();
            PdfPCell overtimeHours50Cell = new PdfPCell(new Phrase(this.amountFormatter.format(overtimeHours50Val.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
            overtimeHours50Cell.setHorizontalAlignment(1);
            footerTable.addCell(overtimeHours50Cell);
            document.add(footerTable);
            PdfPTable netSalaryTable = new PdfPTable(2);
            netSalaryTable.setSpacingBefore(10.0f);
            netSalaryTable.setHorizontalAlignment(2);
            netSalaryTable.setWidthPercentage(50.0f);
            netSalaryTable.setWidths(new float[]{30.0f, 20.0f});
            PdfPCell netLabelCell = new PdfPCell(new Phrase("Salaire net".toUpperCase(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            netLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            netLabelCell.setHorizontalAlignment(1);
            netSalaryTable.addCell(netLabelCell);
            PdfPCell netCell = new PdfPCell(new Phrase(this.amountFormatter.format(payslip.getNetSalary()), new Font(Font.FontFamily.TIMES_ROMAN, 13.0f, 1)));
            netCell.setHorizontalAlignment(2);
            netSalaryTable.addCell(netCell);
            document.add(netSalaryTable);
            document.close();
            return reportDTO;
        }
        catch (Exception e) {
            log.log(Level.ERROR, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

