/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class HeaderFooterPageEvent
extends PdfPageEventHelper {
    private PdfTemplate t;
    private Image total;

    @Override
    public void onOpenDocument(PdfWriter writer, Document document) {
        this.t = writer.getDirectContent().createTemplate(30.0f, 16.0f);
        try {
            this.total = Image.getInstance(this.t);
            this.total.setRole(PdfName.ARTIFACT);
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
        this.addHeader(writer);
        this.addFooter(writer);
    }

    private void addHeader(PdfWriter writer) {
    }

    private void addFooter(PdfWriter writer) {
        PdfPTable footer = new PdfPTable(3);
        try {
            footer.setWidths(new int[]{2, 3, 2});
            footer.setTotalWidth(writer.getPageSize().getWidth());
            footer.setLockedWidth(true);
            footer.getDefaultCell().setFixedHeight(40.0f);
            footer.getDefaultCell().setBorder(0);
            footer.getDefaultCell().setBorderColor(BaseColor.LIGHT_GRAY);
            footer.setHorizontalAlignment(1);
            footer.getDefaultCell().setHorizontalAlignment(1);
            footer.getDefaultCell().setVerticalAlignment(6);
            footer.addCell(new Phrase(String.format("", new Object[0]), new Font(Font.FontFamily.TIMES_ROMAN, 10.0f)));
            footer.addCell(new Phrase(String.format("Page %d", writer.getPageNumber()), new Font(Font.FontFamily.TIMES_ROMAN, 10.0f)));
            footer.addCell(new Phrase(String.format(LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm")), new Object[0]), new Font(Font.FontFamily.TIMES_ROMAN, 10.0f)));
            PdfContentByte canvas = writer.getDirectContent();
            canvas.beginMarkedContentSequence(PdfName.ARTIFACT);
            footer.writeSelectedRows(0, -1, 34.0f, 50.0f, canvas);
            canvas.endMarkedContentSequence();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    @Override
    public void onCloseDocument(PdfWriter writer, Document document) {
    }
}

