/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class GrossTaxableSalaryv2020Impl
implements DeductionBasisService {
    private static Double FEES_ABIDJAN = 30000.0;
    private static Double FEES_BOUAKE = 24000.0;
    private static Double FEES_OTHERS = 20000.0;
    private static Long ABIDJAN_ID = 0L;
    private static Long BOUAKE_ID = 0L;
    private static Double HOUSE_PEOPLE = 60000.0;
    private static Double GUARDIAN = 50000.0;
    private static Double GARDENER = 50000.0;
    private static Double COOKER = 90000.0;
    private static Double SWIM_POOL = 30000.0;
    private static Double AIR_CONDITIONING = 20000.0;
    private static final Double[] HOUSING = new Double[]{60000.0, 80000.0, 160000.0, 300000.0, 480000.0, 600000.0, 800000.0};
    private static final Double[] FURNITURE = new Double[]{10000.0, 20000.0, 40000.0, 60000.0, 80000.0, 100000.0, 150000.0};
    private static final Double[] ELECTRICITY = new Double[]{10000.0, 20000.0, 30000.0, 40000.0, 50000.0, 60000.0, 70000.0};
    private static final Double[] WATER = new Double[]{10000.0, 15000.0, 20000.0, 30000.0, 40000.0, 50000.0, 60000.0};
    private static final String[] EXEMPTED_ITEMS = new String[]{"210", "214", "217", "215", "236", "211", "216"};
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"280", "281", "282", "283", "284", "285", "286", "287", "288", "289", "290", "291", "292", "293", "294", "295", "296"};

    @Override
    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        DeductionBasisContext context = new DeductionBasisContext(CountryCode.CIV, "300", 2020);
        Double grossSalary = context.calculate(params, advantagesInKind);
        Double nonExemptedSalary = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            return all && !Arrays.asList(EXEMPTED_ITEMS).contains(entry.getKey());
        }).mapToDouble(entry -> {
            if ("212".equals(entry.getKey())) {
                Long localityId = (Long)params.get("187");
                if (ABIDJAN_ID.equals(localityId)) {
                    return Math.max(FEES_ABIDJAN - Double.parseDouble(entry.getValue().toString()), 0.0);
                }
                if (BOUAKE_ID.equals(localityId)) {
                    return Math.max(FEES_BOUAKE - Double.parseDouble(entry.getValue().toString()), 0.0);
                }
                return Math.max(FEES_OTHERS - Double.parseDouble(entry.getValue().toString()), 0.0);
            }
            return Double.parseDouble(entry.getValue().toString());
        }).sum();
        Double indemnitiesSalary = params.entrySet().stream().filter(entry -> Arrays.asList(EXEMPTED_ITEMS).contains(entry.getKey())).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        Double nonExemptedIndemnities = Math.max(indemnitiesSalary - grossSalary / 10.0, 0.0);
        Double advantagesInKindAmount = advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> {
            int pieces = advantagesInKind.getOrDefault("146", 0);
            return switch ((String)entry.getKey()) {
                case "280" -> HOUSING[Math.min(6, pieces - 1)];
                case "281" -> FURNITURE[Math.min(6, pieces - 1)];
                case "282" -> {
                    Double poolAmount = advantagesInKind.getOrDefault("291", 0) >= 1 ? SWIM_POOL : 0.0;
                    yield WATER[Math.min(6, pieces - 1)] + poolAmount;
                }
                case "284" -> {
                    int heatedPieces = advantagesInKind.getOrDefault("292", 0);
                    yield ELECTRICITY[Math.min(6, pieces - 1)] + (double)heatedPieces * AIR_CONDITIONING;
                }
                case "288" -> HOUSE_PEOPLE;
                case "286" -> GUARDIAN;
                case "287" -> GARDENER;
                case "289" -> COOKER;
                default -> 0.0;
            };
        }).sum();
        return nonExemptedSalary + advantagesInKindAmount + nonExemptedIndemnities;
    }

    @Override
    public CountryCode country() {
        return CountryCode.CIV;
    }

    @Override
    public String code() {
        return "303";
    }

    @Override
    public int version() {
        return 2020;
    }
}

