/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class ContribSalaryv2004Impl
implements DeductionBasisService {
    private static final String[] PROFESIONAL_FEES_ITEMS = new String[]{"210", "212", "214", "217", "221", "224", "234", "235", "238"};
    private static final String[] EXCEPTIONAL_INCOMES = new String[]{"330", "332", "333"};
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"370", "371", "372", "373", "374", "375"};

    @Override
    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        Double base = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            return all && !Arrays.asList(PROFESIONAL_FEES_ITEMS).contains(entry.getKey());
        }).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        return base + advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "370" -> 0.15 * base;
            case "372" -> 0.04 * base;
            case "371" -> 0.02 * base;
            case "373" -> {
                Double vehicles = Double.parseDouble(((Integer)entry.getValue()).toString());
                yield 0.1 * vehicles * base;
            }
            case "374" -> {
                Double domestics = Double.parseDouble(((Integer)entry.getValue()).toString());
                yield 0.05 * domestics * base;
            }
            case "375" -> 0.1 * base;
            default -> 0.0;
        }).sum();
    }

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public String code() {
        return "306";
    }

    @Override
    public int version() {
        return 2004;
    }
}

