/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class GrossTaxableSalaryv2019Impl
implements DeductionBasisService {
    private static final Double MAX_INTERNSHIP_ALLOWANCE = 500000.0;
    private static final Double MAX_CHILD_ALLOWANCE = 20000.0;
    private static final Double MAX_ACCOMODATION_ALLOWANCE = 250000.0;
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"370", "371", "372", "333", "374"};
    private static final String[] INDEMNITIES_IN_KIND = new String[]{"212", "270", "271", "272", "273"};
    private static final String[] ARTICLES_91_11_ITEMS = new String[]{"220", "219", "250", "251", "330", "331", "338"};
    private static final String[] ARTICLES_91BIS_ITEMS = new String[]{"210", "211", "214", "240", "232", "246", "247", "248", "215"};
    private static final String[] ARTICLES_91TER_ITEMS = new String[]{"334", "335", "333", "336", "337"};

    @Override
    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, "300", 2019);
        Double grossSalary = context.calculate(params, advantagesInKind);
        Double article91BisItemsAmount = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            boolean except = Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey());
            return all && !except;
        }).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        Double cnssAmount = new DeductionContext(CountryCode.GAB, "420", 2016).calculateEmployee(params);
        Double cnamgsAmount = new DeductionContext(CountryCode.GAB, "421", 2016).calculateEmployee(params);
        Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount;
        Double advantagesInKindAmount = advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "370" -> 0.15 * advantagesInKindBasis;
            case "371", "372", "333" -> 0.05 * advantagesInKindBasis;
            case "374" -> 0.25 * advantagesInKindBasis;
            default -> 0.0;
        }).sum();
        Double taxableItemsAmount = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            return all && !Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey()) && !Arrays.asList(ARTICLES_91_11_ITEMS).contains(entry.getKey());
        }).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "212" -> {
                Double grossSalaryBefAcc = grossSalary - Double.parseDouble(entry.getValue().toString());
                Double maxAccAmount = Math.min(0.4 * grossSalaryBefAcc, MAX_ACCOMODATION_ALLOWANCE);
                Double additionalAmount = Math.min(maxAccAmount - Double.parseDouble(entry.getValue().toString()), 0.0);
                yield Math.min(Double.parseDouble(entry.getValue().toString()), 0.15 * advantagesInKindBasis) + additionalAmount;
            }
            case "270", "271", "272" -> Math.min(Double.parseDouble(entry.getValue().toString()), 0.05 * advantagesInKindBasis);
            case "273" -> Math.min(Double.parseDouble(entry.getValue().toString()), Math.min(0.25 * advantagesInKindBasis, 120000.0));
            case "242" -> {
                Double children = params.getOrDefault("144", 0.0);
                yield Math.min(Double.parseDouble(entry.getValue().toString()) - children * MAX_CHILD_ALLOWANCE, 0.0);
            }
            case "252" -> Math.max(Double.parseDouble(entry.getValue().toString()) - MAX_INTERNSHIP_ALLOWANCE, 0.0);
            case "334", "335" -> 0.0;
            case "333", "336" -> 0.5 * Double.parseDouble(entry.getValue().toString());
            default -> Double.parseDouble(entry.getValue().toString());
        }).sum();
        Double article9111ItemsAmount = params.entrySet().stream().filter(entry -> Arrays.asList(ARTICLES_91_11_ITEMS).contains(entry.getKey())).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        return taxableItemsAmount + article9111ItemsAmount + advantagesInKindAmount - cnssAmount - cnamgsAmount;
    }

    @Override
    public CountryCode country() {
        return CountryCode.GAB;
    }

    @Override
    public String code() {
        return "305";
    }

    @Override
    public int version() {
        return 2022;
    }
}

