/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.deduction;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionService;

public class IRPPServicev2019Impl
implements DeductionService {
    private static final Double MAX_TAX_SALARY_REDUCTION = 833333.3333333334;
    Double[] ranges = new Double[]{1500000.0, 1920000.0, 2700000.0, 3600000.0, 5160000.0, 7500000.0, 1.1E7, 9.99999999E8};
    Double[] rates = new Double[]{0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0};
    Double[] deductions = new Double[]{0.0, 75000.0, 171000.0, 306000.0, 486000.0, 744000.0, 1119000.0, 1669000.0};

    @Override
    public Double calculateEmployee(Map<String, Object> params) {
        Double shares = (Double)params.get("147");
        Double taxableSalary = (Double)params.get("305");
        Double incomeTaxBasis = taxableSalary - Math.min(0.2 * taxableSalary, MAX_TAX_SALARY_REDUCTION);
        Double quotient = incomeTaxBasis / shares;
        int index = Arrays.binarySearch((Object[])this.ranges, (Object)(12.0 * quotient));
        return (0.001 * this.rates[index] * quotient - this.deductions[index]) * shares / 12.0;
    }

    @Override
    public Double calculateEmployer(Map<String, Object> params) {
        return 0.0;
    }

    @Override
    public CountryCode country() {
        return CountryCode.GAB;
    }

    @Override
    public String code() {
        return "400";
    }

    @Override
    public int version() {
        return 2022;
    }
}

