/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.employee.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import tech.deepdreams.employee.events.ContractUpdatedEvent;

public class ContractUpdatedEventSerializer
extends JsonSerializer<ContractUpdatedEvent> {
    @Override
    public void serialize(ContractUpdatedEvent event, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("id", event.getId());
        jsonGenerator.writeNumberField("employeeId", event.getEmployeeId());
        jsonGenerator.writeStringField("eventDate", event.getEventDate().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        jsonGenerator.writeStringField("hiringDate", event.getHiringDate().format(DateTimeFormatter.ISO_DATE));
        jsonGenerator.writeStringField("contractType", event.getContractType().name());
        jsonGenerator.writeNumberField("contractDuration", event.getContractDuration());
        jsonGenerator.writeNumberField("baseSalary", event.getBaseSalary());
        jsonGenerator.writeNumberField("weeklyWorkingHours", event.getWeeklyWorkingHours());
        jsonGenerator.writeNumberField("annualLeaveDays", event.getAnnualLeaveDays());
        jsonGenerator.writeNumberField("retirementAge", event.getRetirementAge());
        jsonGenerator.writeNumberField("unitId", event.getUnitId());
        jsonGenerator.writeNumberField("functionId", event.getFunctionId());
        jsonGenerator.writeNumberField("categoryId", event.getCategoryId());
        jsonGenerator.writeNumberField("echelonId", event.getEchelonId());
        jsonGenerator.writeStringField("username", event.getUsername());
        jsonGenerator.writeEndObject();
    }
}

