/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.service.ObjectVendorExtension;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class VendorExtensionsReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(VendorExtensionsReader.class);

    @Override
    public void apply(OperationContext context) {
        Optional<ApiOperation> apiOperation = context.findAnnotation(ApiOperation.class);
        if (apiOperation.isPresent()) {
            Extension[] extensionsAnnotations = apiOperation.get().extensions();
            List<VendorExtension> extensions = this.readExtensions(extensionsAnnotations);
            LOG.debug("Extension count {} for method {}", (Object)extensions.size(), (Object)context.getName());
            context.operationBuilder().extensions(extensions);
        }
    }

    private List<VendorExtension> readExtensions(Extension[] vendorAnnotations) {
        return Stream.of(vendorAnnotations).map(this.toVendorExtension()).collect(Collectors.toList());
    }

    private Function<Extension, VendorExtension> toVendorExtension() {
        return input -> Optional.ofNullable(input.name()).filter(((Predicate<String>)String::isEmpty).negate()).map(this.propertyExtension((Extension)input)).orElse(this.objectExtension((Extension)input));
    }

    private VendorExtension objectExtension(Extension each) {
        ObjectVendorExtension extension = new ObjectVendorExtension(this.ensurePrefixed(Optional.ofNullable(each.name()).orElse("")));
        for (ExtensionProperty property : each.properties()) {
            if (StringUtils.isEmpty(property.name()) || StringUtils.isEmpty(property.value())) continue;
            extension.addProperty(new StringVendorExtension(property.name(), property.value()));
        }
        return extension;
    }

    private Function<String, VendorExtension> propertyExtension(Extension annotation) {
        return input -> {
            ObjectVendorExtension extension = new ObjectVendorExtension(this.ensurePrefixed((String)input));
            for (ExtensionProperty each : annotation.properties()) {
                extension.addProperty(new StringVendorExtension(each.name(), each.value()));
            }
            return extension;
        };
    }

    private String ensurePrefixed(String name) {
        if (!StringUtils.isEmpty(name) && !name.startsWith("x-")) {
            return "x-" + name;
        }
        return name;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

