/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483638)
public class ParameterDataTypeReader
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterDataTypeReader.class);
    private final TypeNameExtractor nameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final SchemaPluginsManager pluginsManager;
    private final ModelSpecificationFactory models;

    @Autowired
    public ParameterDataTypeReader(SchemaPluginsManager pluginsManager, TypeNameExtractor nameExtractor, EnumTypeDeterminer enumTypeDeterminer, ModelSpecificationFactory models) {
        this.nameExtractor = nameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.pluginsManager = pluginsManager;
        this.models = models;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public void apply(ParameterContext context) {
        ResolvedMethodParameter methodParameter = context.resolvedMethodParameter();
        ResolvedType parameterType = methodParameter.getParameterType();
        parameterType = context.alternateFor(parameterType);
        ModelReference modelRef = null;
        ModelContext modelContext = this.modelContext(context, methodParameter, parameterType);
        ModelSpecification parameterModel = this.models.create(modelContext, parameterType);
        if (methodParameter.hasParameterAnnotation(PathVariable.class) && this.treatAsAString(parameterType)) {
            modelRef = new ModelRef("string");
            context.requestParameterBuilder().query(q -> q.model(m -> m.scalarModel(ScalarType.STRING)));
        } else if (methodParameter.hasParameterAnnotation(RequestParam.class) && Maps.isMapType(parameterType)) {
            modelRef = new ModelRef("", new ModelRef("string"), true);
            context.requestParameterBuilder().query(q -> q.model(m -> m.mapModel(map -> map.key(v -> v.scalarModel(ScalarType.STRING)).value(v -> v.scalarModel(ScalarType.STRING)))));
        } else if (methodParameter.hasParameterAnnotation(RequestPart.class) || methodParameter.hasParameterAnnotation(RequestBody.class)) {
            context.requestParameterBuilder().contentModel(parameterModel);
        } else {
            modelRef = this.handleFormParameter(context, parameterType, modelRef, parameterModel);
        }
        context.parameterBuilder().type(parameterType).modelRef(Optional.ofNullable(modelRef).orElse((ModelRef)ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.nameExtractor).apply(parameterType)));
    }

    private ModelReference handleFormParameter(ParameterContext context, ResolvedType parameterType, ModelReference modelRef, ModelSpecification parameterModel) {
        if (this.treatRequestParamAsString(parameterType)) {
            modelRef = new ModelRef("string");
            context.requestParameterBuilder().query(q -> q.model(m -> m.scalarModel(ScalarType.STRING)));
        } else if (Collections.isContainerType(parameterType) && context.getDocumentationType() == DocumentationType.OAS_30) {
            modelRef = new ModelRef("string");
            context.requestParameterBuilder().query(q -> q.model(m -> m.scalarModel(this.collectionItemScalarType(parameterModel))).explode(true));
        } else {
            String typeName = Types.typeNameFor(parameterType.getErasedType());
            if (ScalarTypes.builtInScalarType(parameterType).isPresent()) {
                modelRef = new ModelRef(typeName);
            }
            context.requestParameterBuilder().query(q -> q.model(m -> m.copyOf(parameterModel)));
        }
        return modelRef;
    }

    private ScalarType collectionItemScalarType(ModelSpecification parameterModel) {
        return parameterModel.getCollection().map(c -> c.getModel().getScalar().map(ScalarModelSpecification::getType).orElse(ScalarType.STRING)).orElseGet(() -> {
            LOG.warn("Could not infer parameter type: " + parameterModel);
            return ScalarType.STRING;
        });
    }

    private ModelContext modelContext(ParameterContext context, ResolvedMethodParameter methodParameter, ResolvedType parameterType) {
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        return context.getOperationContext().operationModelsBuilder().addInputParam(parameterType, viewProvider.viewFor(methodParameter), new HashSet<ResolvedType>());
    }

    private boolean treatRequestParamAsString(ResolvedType parameterType) {
        return this.treatAsAString(parameterType) && !Collections.isContainerType(parameterType) || Collections.isContainerType(parameterType) && this.treatAsAString(Collections.collectionElementType(parameterType));
    }

    private boolean treatAsAString(ResolvedType parameterType) {
        return !ScalarTypes.builtInScalarType(parameterType.getErasedType()).isPresent() && !this.enumTypeDeterminer.isEnum(parameterType.getErasedType());
    }
}

