/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class OperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(OperationResponseClassReader.class);
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor nameExtractor;
    private final SchemaPluginsManager pluginsManager;

    @Autowired
    public OperationResponseClassReader(SchemaPluginsManager pluginsManager, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor nameExtractor) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.nameExtractor = nameExtractor;
        this.pluginsManager = pluginsManager;
    }

    @Override
    public void apply(OperationContext context) {
        ResolvedType returnType2 = context.getReturnType();
        returnType2 = context.alternateFor(returnType2);
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        ModelContext modelContext = context.operationModelsBuilder().addReturn(returnType2, viewProvider.viewFor(context));
        HashMap<String, String> knownNames = new HashMap<String, String>();
        ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting spring response class to: {}", (Object)responseTypeName);
        context.operationBuilder().responseModel(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.nameExtractor, knownNames).apply(returnType2));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

