/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Paths {
    public static final String ROOT = "/";
    private static final Pattern FIRST_PATH_FRAGMENT_REGEX = Pattern.compile("^([/]?[\\w\\-.]+[/]?)");

    private Paths() {
        throw new UnsupportedOperationException();
    }

    public static String splitCamelCase(String s, String separator) {
        if (StringUtils.isEmpty(s)) {
            return "";
        }
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), separator);
    }

    public static String stripSlashes(String stringWithSlashes) {
        return stringWithSlashes.replace(ROOT, "").replace("\\", "");
    }

    public static String maybeChompLeadingSlash(String path) {
        if (StringUtils.isEmpty(path) || !path.startsWith(ROOT)) {
            return path;
        }
        return path.replaceFirst("^/", "");
    }

    public static String maybeChompTrailingSlash(String path) {
        if (StringUtils.isEmpty(path) || !path.endsWith(ROOT)) {
            return path;
        }
        return path.replaceFirst("/$", "");
    }

    public static String firstPathSegment(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        Matcher matcher = FIRST_PATH_FRAGMENT_REGEX.matcher(path);
        if (matcher.find()) {
            return Paths.maybeChompTrailingSlash(matcher.group());
        }
        return path;
    }

    public static String sanitizeRequestMappingPattern(String requestMappingPattern) {
        String result = requestMappingPattern;
        result = result.replaceAll("\\{([^}]+?):([^/{}]|\\{[\\d,]+})+}", "{$1}");
        return Paths.rootPathWhenEmpty(result);
    }

    public static String removeAdjacentForwardSlashes(String candidate) {
        return candidate.replaceAll("(?<!(http:|https:))//", ROOT);
    }

    public static String contextPath(String contextPath) {
        return Paths.rootPathWhenEmpty(contextPath);
    }

    public static String rootPathWhenEmpty(String path) {
        return !StringUtils.isEmpty(path) ? path : ROOT;
    }
}

