/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;

public class WebMvcObjectMapperConfigurer
implements BeanPostProcessor,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof RequestMappingHandlerAdapter) {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean2;
            adapter.setMessageConverters(this.configureMessageConverters(adapter.getMessageConverters()));
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private List<HttpMessageConverter<?>> configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        Iterable<MappingJackson2HttpMessageConverter> jackson2Converters = this.jackson2Converters(converters);
        if (StreamSupport.stream(jackson2Converters.spliterator(), false).count() > 0L) {
            for (MappingJackson2HttpMessageConverter each : jackson2Converters) {
                this.fireObjectMapperConfiguredEvent(each.getObjectMapper());
            }
        } else {
            converters.add((HttpMessageConverter<?>)this.configuredMessageConverter());
        }
        return new ArrayList(converters);
    }

    private Iterable<MappingJackson2HttpMessageConverter> jackson2Converters(List<HttpMessageConverter<?>> messageConverters) {
        List<MappingJackson2HttpMessageConverter> converters = messageConverters.stream().filter(MappingJackson2HttpMessageConverter.class::isInstance).map(MappingJackson2HttpMessageConverter.class::cast).collect(Collectors.toList());
        Collections.reverse(converters);
        return converters;
    }

    private MappingJackson2HttpMessageConverter configuredMessageConverter() {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        messageConverter.setObjectMapper(objectMapper);
        this.fireObjectMapperConfiguredEvent(objectMapper);
        return messageConverter;
    }

    private void fireObjectMapperConfiguredEvent(ObjectMapper objectMapper) {
        this.applicationEventPublisher.publishEvent(new ObjectMapperConfigured(this, objectMapper));
    }
}

