/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class ContribSalaryv2016Impl
implements DeductionBasisService {
    private static final String[] ARTICLES_91BIS_ITEMS = new String[]{"210", "211", "214", "240", "232", "246", "247", "248", "215"};
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"370", "371", "372", "333", "374"};
    private static final String[] REFUNDED_ITEMS = new String[]{"214", "248", "253", "254", "246", "255", "256", "221", "257", "258", "267", "268", "336", "334", "269", "259", "217", "260", "261", "262", "263", "264", "265", "266"};

    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, "300", 2019);
        Double grossSalary = context.calculate(params, advantagesInKind);
        Double article91BisItemsAmount = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            boolean except = Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey());
            return all && !except;
        }).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        Double cnssAmount = new DeductionContext(CountryCode.GAB, "420", 2016).calculateEmployee(params);
        Double cnamgsAmount = new DeductionContext(CountryCode.GAB, "421", 2016).calculateEmployee(params);
        Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount;
        Double advantagesInKindAmount = advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "370" -> 0.06 * advantagesInKindBasis;
            case "371", "372", "333" -> 0.05 * advantagesInKindBasis;
            case "374" -> 0.25 * advantagesInKindBasis;
            default -> 0.0;
        }).sum();
        Double taxableSalary = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            return all && !Arrays.asList(REFUNDED_ITEMS).contains(entry.getKey());
        }).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "333" -> 0.5 * Double.parseDouble(entry.getValue().toString());
            default -> Double.parseDouble(entry.getValue().toString());
        }).sum();
        return taxableSalary + advantagesInKindAmount;
    }

    public CountryCode country() {
        return CountryCode.GAB;
    }

    public String code() {
        return "306";
    }

    public int version() {
        return 2016;
    }
}

