/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class AdvantagesInKindSalaryv2022Impl
implements DeductionBasisService {
    private static final String[] ARTICLES_91BIS_ITEMS = new String[]{"210", "211", "214", "240", "232", "246", "247", "248", "215"};
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"370", "371", "372", "333", "374"};

    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, "300", 2019);
        Double grossSalary = context.calculate(params, advantagesInKind);
        Double article91BisItemsAmount = params.entrySet().stream().filter(entry -> Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey())).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        Double cnssAmount = new DeductionContext(CountryCode.GAB, "420", 2016).calculateEmployee(params);
        Double cnamgsAmount = new DeductionContext(CountryCode.GAB, "421", 2016).calculateEmployee(params);
        Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount;
        return advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "370" -> 0.15 * advantagesInKindBasis;
            case "371", "372", "333" -> 0.05 * advantagesInKindBasis;
            case "374" -> 0.25 * advantagesInKindBasis;
            default -> 0.0;
        }).sum();
    }

    public CountryCode country() {
        return CountryCode.GAB;
    }

    public String code() {
        return "302";
    }

    public int version() {
        return 2022;
    }
}

