/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.api.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class NumberToolkit {
    private Logger logger = Logger.getLogger(NumberToolkit.class.getName());
    private static NumberToolkit instance = null;
    public static final String PERCENTAGE_FORMAT = "#0.00";
    public static final String MONTANT_FORMAT = "##,###";

    private NumberToolkit() {
    }

    public static final NumberToolkit getInstance() {
        if (instance == null) {
            instance = new NumberToolkit();
        }
        return instance;
    }

    public String format(Double number, String format) {
        if (number == null) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat(format);
        return formatter.format(number);
    }

    public String format(Long number, String format) {
        if (number == null) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat(format);
        return formatter.format(number);
    }

    public static String Unite(String x) {
        String ch = "";
        switch (Integer.parseInt(x)) {
            case 0: {
                ch = "z\ufffdro";
                break;
            }
            case 1: {
                ch = "un";
                break;
            }
            case 2: {
                ch = "deux";
                break;
            }
            case 3: {
                ch = "trois";
                break;
            }
            case 4: {
                ch = "quatre";
                break;
            }
            case 5: {
                ch = "cinq";
                break;
            }
            case 6: {
                ch = "six";
                break;
            }
            case 7: {
                ch = "sept";
                break;
            }
            case 8: {
                ch = "huit";
                break;
            }
            case 9: {
                ch = "neuf";
            }
        }
        return ch;
    }

    public static String Dizaine(String x) {
        Object ch = "";
        String x1 = x.substring(0, 1);
        String x2 = x.substring(1, 2);
        block0 : switch (Integer.parseInt(x1)) {
            case 0: {
                ch = NumberToolkit.Unite(x2);
                break;
            }
            case 1: {
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "dix";
                        break;
                    }
                    case 1: {
                        ch = "onze";
                        break;
                    }
                    case 2: {
                        ch = "douze";
                        break;
                    }
                    case 3: {
                        ch = "treize";
                        break;
                    }
                    case 4: {
                        ch = "quatorze";
                        break;
                    }
                    case 5: {
                        ch = "quinze";
                        break;
                    }
                    case 6: {
                        ch = "seize";
                        break;
                    }
                    case 7: {
                        ch = "dix-sept";
                        break;
                    }
                    case 8: {
                        ch = "dix-huit";
                        break;
                    }
                    case 9: {
                        ch = "dix-neuf";
                    }
                }
                break;
            }
            case 2: {
                ch = "vingt";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "vingt";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 3: {
                ch = "trente";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "trente";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 4: {
                ch = "quarante";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "quarante";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 5: {
                ch = "cinquante";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "cinquante";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 6: {
                ch = "soixante";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "soixante";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 7: {
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "soixante dix";
                        break;
                    }
                    case 1: {
                        ch = "soixante onze";
                        break;
                    }
                    case 2: {
                        ch = "soixante douze";
                        break;
                    }
                    case 3: {
                        ch = "soixante treize";
                        break;
                    }
                    case 4: {
                        ch = "soixante quatorze";
                        break;
                    }
                    case 5: {
                        ch = "soixante quinze";
                        break;
                    }
                    case 6: {
                        ch = "soixante seize";
                        break;
                    }
                    case 7: {
                        ch = "soixante dix-sept";
                        break;
                    }
                    case 8: {
                        ch = "soixante dix-huit";
                        break;
                    }
                    case 9: {
                        ch = "soixante dix-neuf";
                    }
                }
                break;
            }
            case 8: {
                ch = "quatre-vingt";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "quatre-vingts";
                        break block0;
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Unite(x2);
                break;
            }
            case 9: {
                ch = "quatre-vingt dix";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        ch = "quatre-vingt dix";
                        break block0;
                    }
                    case 1: {
                        ch = "quatre-vingt onze";
                        break block0;
                    }
                    case 2: {
                        ch = "quatre-vingt douze";
                        break block0;
                    }
                    case 3: {
                        ch = "quatre-vingt treize";
                        break block0;
                    }
                    case 4: {
                        ch = "quatre-vingt quatorze";
                        break block0;
                    }
                    case 5: {
                        ch = "quatre-vingt quinze";
                        break block0;
                    }
                    case 6: {
                        ch = "quatre-vingt seize";
                        break block0;
                    }
                    case 7: {
                        ch = "quatre-vingt dix-sept";
                        break block0;
                    }
                    case 8: {
                        ch = "quatre-vingt dix-huit";
                        break block0;
                    }
                    case 9: {
                        ch = "quatre-vingt dix-neuf";
                    }
                }
            }
        }
        return ch;
    }

    public static String Centaine(String x) {
        Object ch = "";
        if (x.length() == 1) {
            ch = NumberToolkit.Unite(x);
            return ch;
        }
        if (x.length() == 2) {
            ch = NumberToolkit.Dizaine(x);
            return ch;
        }
        String x1 = x.substring(0, 1);
        String x2 = x.substring(1, 2);
        String x3 = x.substring(2, 3);
        block0 : switch (Integer.parseInt(x1)) {
            case 0: {
                ch = NumberToolkit.Dizaine(x2 + x3);
                break;
            }
            case 1: {
                ch = "cent";
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        switch (Integer.parseInt(x3)) {
                            default: 
                        }
                        ch = (String)ch + " " + NumberToolkit.Unite(x3);
                    }
                }
                ch = (String)ch + " " + NumberToolkit.Dizaine(x2 + x3);
                break;
            }
            default: {
                ch = NumberToolkit.Unite(x1);
                switch (Integer.parseInt(x2)) {
                    case 0: {
                        switch (Integer.parseInt(x3)) {
                            case 0: {
                                ch = (String)ch + " cents";
                                break block0;
                            }
                        }
                        ch = (String)ch + " cent " + NumberToolkit.Unite(x3);
                        break block0;
                    }
                }
                ch = (String)ch + " cent " + NumberToolkit.Dizaine(x2 + x3);
            }
        }
        return ch;
    }

    public static String Mille(String x) {
        Object ch = "";
        int i = x.length() - 3;
        String x1 = x.substring(0, i);
        String x2 = x.substring(i, x.length());
        ch = Integer.parseInt(x1) == 0 ? NumberToolkit.Centaine(x2) : (Integer.parseInt(x2) == 0 ? NumberToolkit.Centaine(x1) + " mille " : NumberToolkit.Centaine(x1) + " mille " + NumberToolkit.Centaine(x2));
        return ch;
    }

    public static String Million(String x) {
        Object ch = "";
        int i = x.length() - 6;
        String x1 = x.substring(0, i);
        String x2 = x.substring(i, x.length());
        ch = Integer.parseInt(x1) == 0 ? NumberToolkit.Mille(x2) : (Integer.parseInt(x2) == 0 ? NumberToolkit.Centaine(x1) + " million(s) " : NumberToolkit.Centaine(x1) + " million(s) " + NumberToolkit.Mille(x2));
        return ch;
    }

    public static String Milliard(String x) {
        Object ch = "";
        int i = x.length() - 9;
        String x1 = x.substring(0, i);
        String x2 = x.substring(i, x.length());
        ch = Integer.parseInt(x1) == 0 ? NumberToolkit.Million(x2) : (Integer.parseInt(x2) == 0 ? NumberToolkit.Centaine(x1) + " milliard(s) " : NumberToolkit.Centaine(x1) + " milliard(s) " + NumberToolkit.Million(x2));
        return ch;
    }

    public static String convertToLetters(Long montant) {
        String montantChiffre = Long.toString(montant);
        String montantLettre = "";
        if (montantChiffre.length() >= 10) {
            return NumberToolkit.Milliard(montantChiffre);
        }
        montantLettre = montantChiffre.length() >= 7 ? NumberToolkit.Million(montantChiffre) : (montantChiffre.length() >= 4 ? NumberToolkit.Mille(montantChiffre) : (montantChiffre.length() >= 3 ? NumberToolkit.Centaine(montantChiffre) : (montantChiffre.length() >= 2 ? NumberToolkit.Dizaine(montantChiffre) : (montantChiffre.length() >= 1 ? NumberToolkit.Unite(montantChiffre) : ""))));
        char firstChar = montantLettre.charAt(0);
        if ((montantLettre = montantLettre.replaceFirst("" + firstChar, ("" + firstChar).toUpperCase())).endsWith("un un")) {
            montantLettre = montantLettre.substring(0, montantLettre.length() - 3);
        }
        return montantLettre;
    }

    public BigDecimal evaluer(String formule, Map<String, Object> params) throws Exception {
        try {
            Set<String> keys = params.keySet();
            Expression expression = new ExpressionBuilder(formule).variables(keys).build();
            for (String key : keys) {
                if (params.get(key) == null) continue;
                expression.setVariable(key, Double.parseDouble(params.get(key).toString()));
            }
            Double resultat = expression.evaluate();
            return BigDecimal.valueOf(Double.parseDouble(((Object)resultat).toString()));
        }
        catch (Exception e) {
            this.logger.info("Erreur : " + e.getMessage());
            return BigDecimal.ZERO;
        }
    }

    public static void main(String[] args) {
        try {
            Double val1 = 0.3;
            Double val2 = 0.1;
            System.out.println("val1 - val2 = " + (val1 - val2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

