/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.util.function.Predicate;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import space.jasan.support.groovy.closure.GroovyClosure;

public class PredicateWithDelegate<T>
implements Predicate<T> {
    private final int strategy;
    private final Object owner;
    private final Closure<?> closure;

    public static <T> Predicate<T> create(Closure<?> c, Object owner, int strategy) {
        return new PredicateWithDelegate<T>(c, strategy, owner);
    }

    public static <T> Predicate<T> create(Closure<?> c, Object owner) {
        return PredicateWithDelegate.create(c, owner, 1);
    }

    public static <T> Predicate<T> create(Closure<?> c, int strategy) {
        return PredicateWithDelegate.create(c, GroovyClosure.getPropagatedOwner(c.getOwner()), strategy);
    }

    public static <T> Predicate<T> create(Closure<?> c) {
        return PredicateWithDelegate.create(c, 1);
    }

    private PredicateWithDelegate(Closure<?> closure, int strategy, Object owner) {
        this.strategy = strategy;
        this.owner = owner;
        this.closure = closure;
    }

    @Override
    public boolean test(T t) {
        Closure closure = this.closure.rehydrate(t, this.owner, this.closure.getThisObject());
        closure.setResolveStrategy(this.strategy);
        Object result = closure.call(t);
        if (result == null) {
            return false;
        }
        return (Boolean)DefaultGroovyMethods.asType((Object)result, Boolean.class);
    }
}

