/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public class GroovyClosure {
    private static final int DELEGATE_FIRST = 1;
    private static final String CLOSURE_CLASS_NAME = "groovy.lang.Closure";
    private static final Class<?> CLOSURE_CLASS = GroovyClosure.getClassIfAvailable("groovy.lang.Closure");
    private static final String CONVERSION_HANDLER_CLASS_NAME = "org.codehaus.groovy.runtime.ConversionHandler";
    private static final Class<?> CONVERSION_HANDLER_CLASS = GroovyClosure.getClassIfAvailable("org.codehaus.groovy.runtime.ConversionHandler");
    private static final String SET_DELEGATE_NAME = "setDelegate";
    private static final Method SET_DELEGATE_METHOD;
    private static final String SET_RESOLVE_STRATEGY_NAME = "setResolveStrategy";
    private static final Method SET_RESOLVE_STRATEGY_METHOD;
    private static final String GET_DELEGATE_NAME = "getDelegate";
    private static final Method GET_DELEGATE_METHOD;
    private static final String SAM_PROXY_SUFFIX = "_groovyProxy";
    private static final String SAM_PROXY_MAP_FIELD = "$closures$delegate$map";

    private static Class<?> getClassIfAvailable(String name) {
        Class<?> closureClass;
        try {
            closureClass = Class.forName(name, false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            closureClass = null;
        }
        return closureClass;
    }

    public static <T> T setDelegate(T potentialClosure, Object delegateWanted) {
        if (potentialClosure == null || CLOSURE_CLASS == null || SET_RESOLVE_STRATEGY_METHOD == null || SET_DELEGATE_METHOD == null) {
            return potentialClosure;
        }
        if (Proxy.isProxyClass(potentialClosure.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(potentialClosure);
            if (CONVERSION_HANDLER_CLASS.isInstance(handler)) {
                try {
                    Object shouldBeClosure = GET_DELEGATE_METHOD.invoke((Object)handler, new Object[0]);
                    GroovyClosure.setDelegate(shouldBeClosure, delegateWanted);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get closure delegate from " + handler, e);
                }
            }
        } else {
            if (CLOSURE_CLASS.isInstance(potentialClosure)) {
                try {
                    SET_RESOLVE_STRATEGY_METHOD.invoke(potentialClosure, 1);
                    SET_DELEGATE_METHOD.invoke(potentialClosure, delegateWanted);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set delegate " + delegateWanted + " to " + potentialClosure, e);
                }
            }
            if (potentialClosure.getClass().getSimpleName().endsWith(SAM_PROXY_SUFFIX)) {
                try {
                    Class<?> proxyClass = potentialClosure.getClass();
                    Field field = proxyClass.getDeclaredField(SAM_PROXY_MAP_FIELD);
                    field.setAccessible(true);
                    Object delegateMapValue = field.get(potentialClosure);
                    if (!(delegateMapValue instanceof Map)) {
                        throw new IllegalStateException("Map field is not a map: " + delegateMapValue);
                    }
                    Map delegateMap = (Map)delegateMapValue;
                    if (delegateMap.size() != 1) {
                        throw new IllegalStateException("Map field contains unexpected number of items: " + delegateMap.size());
                    }
                    GroovyClosure.setDelegate(delegateMap.values().iterator().next(), delegateWanted);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set closure delegate to " + potentialClosure, e);
                }
            }
        }
        return potentialClosure;
    }

    public static Object getPropagatedOwner(Object object) {
        if (object instanceof Closure) {
            return ((Closure)object).getOwner();
        }
        return object;
    }

    public static <T> Closure<T> cloneWithTopLevelOwner(Closure<T> closure) {
        return GroovyClosure.cloneWithTopLevelOwner(closure, closure.getDelegate());
    }

    public static <T> Closure<T> cloneWithTopLevelOwner(Closure<T> closure, Object delegate) {
        return GroovyClosure.cloneWithTopLevelOwner(closure, delegate, 1);
    }

    public static <T> Closure<T> cloneWithTopLevelOwner(Closure<T> closure, Object delegate, int strategy) {
        Closure clone = closure.rehydrate(delegate, GroovyClosure.getPropagatedOwner(closure.getOwner()), closure.getThisObject());
        clone.setResolveStrategy(strategy);
        return clone;
    }

    static {
        Method setDelegateMethod = null;
        Method setResolveStrategyMethod = null;
        if (CLOSURE_CLASS != null) {
            try {
                setDelegateMethod = CLOSURE_CLASS.getMethod(SET_DELEGATE_NAME, Object.class);
                setResolveStrategyMethod = CLOSURE_CLASS.getMethod(SET_RESOLVE_STRATEGY_NAME, Integer.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException("Closure class does not contain expected methods", nsme);
            }
        }
        SET_DELEGATE_METHOD = setDelegateMethod;
        SET_RESOLVE_STRATEGY_METHOD = setResolveStrategyMethod;
        Method getDelegateMethod = null;
        if (CONVERSION_HANDLER_CLASS != null) {
            try {
                getDelegateMethod = CONVERSION_HANDLER_CLASS.getMethod(GET_DELEGATE_NAME, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException("Converted closure class does not contain expected methods", nsme);
            }
        }
        GET_DELEGATE_METHOD = getDelegateMethod;
    }
}

