/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.util.function.Function;
import space.jasan.support.groovy.closure.GroovyClosure;

public class FunctionWithDelegate<T, R>
implements Function<T, R> {
    private final int strategy;
    private final Object owner;
    private final Closure<R> closure;

    public static <T, R> Function<T, R> create(Closure<R> c, Object owner, int strategy) {
        return new FunctionWithDelegate<T, R>(c, strategy, owner);
    }

    public static <T, R> Function<T, R> create(Closure<R> c, Object owner) {
        return FunctionWithDelegate.create(c, owner, 1);
    }

    public static <T, R> Function<T, R> create(Closure<R> c, int strategy) {
        return FunctionWithDelegate.create(c, GroovyClosure.getPropagatedOwner(c.getOwner()), strategy);
    }

    public static <T, R> Function<T, R> create(Closure<R> c) {
        return FunctionWithDelegate.create(c, 1);
    }

    private FunctionWithDelegate(Closure<R> closure, int strategy, Object owner) {
        this.strategy = strategy;
        this.owner = owner;
        this.closure = closure;
    }

    @Override
    public R apply(T t) {
        Closure closure = this.closure.rehydrate(t, this.owner, this.closure.getThisObject());
        closure.setResolveStrategy(this.strategy);
        return (R)closure.call(t);
    }
}

