/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.util.function.Consumer;
import space.jasan.support.groovy.closure.GroovyClosure;

public class ConsumerWithDelegate<T>
implements Consumer<T> {
    private final int strategy;
    private final Object owner;
    private final Closure closure;

    public static <T> Consumer<T> create(Closure c, Object owner, int strategy) {
        return new ConsumerWithDelegate<T>(c, strategy, owner);
    }

    public static <T> Consumer<T> create(Closure c, Object owner) {
        return ConsumerWithDelegate.create(c, owner, 1);
    }

    public static <T> Consumer<T> create(Closure c, int strategy) {
        return ConsumerWithDelegate.create(c, GroovyClosure.getPropagatedOwner(c.getOwner()), strategy);
    }

    public static <T> Consumer<T> create(Closure c) {
        return ConsumerWithDelegate.create(c, 1);
    }

    private ConsumerWithDelegate(Closure closure, int strategy, Object owner) {
        this.strategy = strategy;
        this.owner = owner;
        this.closure = closure;
    }

    @Override
    public void accept(T t) {
        Closure closure = this.closure.rehydrate(t, this.owner, this.closure.getThisObject());
        closure.setResolveStrategy(this.strategy);
        closure.call(t);
    }
}

