/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.util.function.BiFunction;
import space.jasan.support.groovy.closure.GroovyClosure;

public class BiFunctionWithDelegate<D, T, R>
implements BiFunction<D, T, R> {
    private final int strategy;
    private final Object owner;
    private final Closure<R> closure;

    public static <D, T, R> BiFunction<D, T, R> create(Closure<R> c, Object owner, int strategy) {
        return new BiFunctionWithDelegate<D, T, R>(c, strategy, owner);
    }

    public static <D, T, R> BiFunction<D, T, R> create(Closure<R> c, Object owner) {
        return BiFunctionWithDelegate.create(c, owner, 1);
    }

    public static <D, T, R> BiFunction<D, T, R> create(Closure<R> c, int strategy) {
        return BiFunctionWithDelegate.create(c, GroovyClosure.getPropagatedOwner(c.getOwner()), strategy);
    }

    public static <D, T, R> BiFunction<D, T, R> create(Closure<R> c) {
        return BiFunctionWithDelegate.create(c, 1);
    }

    private BiFunctionWithDelegate(Closure<R> closure, int strategy, Object owner) {
        this.strategy = strategy;
        this.owner = owner;
        this.closure = closure;
    }

    @Override
    public R apply(D d, T t) {
        Closure closure = this.closure.rehydrate(d, this.owner, this.closure.getThisObject());
        closure.setResolveStrategy(this.strategy);
        return (R)closure.call(t);
    }
}

