/*
 * Decompiled with CFR 0.152.
 */
package space.jasan.support.groovy.closure;

import groovy.lang.Closure;
import java.util.function.BiConsumer;
import space.jasan.support.groovy.closure.GroovyClosure;

public class BiConsumerWithDelegate<D, T>
implements BiConsumer<D, T> {
    private final int strategy;
    private final Object owner;
    private final Closure closure;

    public static <D, T> BiConsumer<D, T> create(Closure c, Object owner, int strategy) {
        return new BiConsumerWithDelegate<D, T>(c, strategy, owner);
    }

    public static <D, T> BiConsumer<D, T> create(Closure c, Object owner) {
        return BiConsumerWithDelegate.create(c, owner, 1);
    }

    public static <D, T> BiConsumer<D, T> create(Closure c, int strategy) {
        return BiConsumerWithDelegate.create(c, GroovyClosure.getPropagatedOwner(c.getOwner()), strategy);
    }

    public static <D, T> BiConsumer<D, T> create(Closure c) {
        return BiConsumerWithDelegate.create(c, 1);
    }

    private BiConsumerWithDelegate(Closure closure, int strategy, Object owner) {
        this.strategy = strategy;
        this.owner = owner;
        this.closure = closure;
    }

    @Override
    public void accept(D d, T t) {
        Closure closure = this.closure.rehydrate(d, this.owner, this.closure.getThisObject());
        closure.setResolveStrategy(this.strategy);
        closure.call(t);
    }
}

