/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.wizard.steps;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.details.Details;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.DataProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.Format;
import software.xdev.vaadin.grid_exporter.format.SpecificConfig;
import software.xdev.vaadin.grid_exporter.format.SpecificConfigComponent;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizardState;
import software.xdev.vaadin.grid_exporter.wizard.steps.AbstractGridExportWizardStepComposite;

public class FormatStep<T>
extends AbstractGridExportWizardStepComposite<VerticalLayout, T> {
    protected final Binder<GridExporterWizardState<T>> binder = new Binder();
    protected final ComboBox<Format> cbFormats = new ComboBox();
    protected final VerticalLayout vlConfigs = new VerticalLayout();
    protected List<? extends SpecificConfigComponent<? extends SpecificConfig>> configComponents = Collections.emptyList();

    public FormatStep(Translator translator) {
        super(translator);
        this.setStepName(this.translate("gridexporter.format"));
        this.initUI();
        this.registerListeners();
        this.initBindings();
    }

    protected void initUI() {
        this.cbFormats.setLabel(this.translate("gridexporter.format"));
        this.cbFormats.setItemLabelGenerator(Format::getFormatNameToDisplay);
        this.cbFormats.setWidthFull();
        this.cbFormats.setMaxWidth("16em");
        this.vlConfigs.setSpacing(false);
        this.vlConfigs.setPadding(false);
        this.vlConfigs.setSizeFull();
        ((VerticalLayout)this.getContent()).add(new Component[]{this.cbFormats, this.vlConfigs});
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).setSizeFull();
    }

    protected void registerListeners() {
        this.cbFormats.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            Format newFormat = (Format)ev.getValue();
            this.showConfigComponentsFor(newFormat);
            if (newFormat == null) {
                return;
            }
            this.bindConfigComponents((GridExporterWizardState)this.getWizardState(), true);
        });
    }

    protected void showConfigComponentsFor(Format format) {
        this.vlConfigs.removeAll();
        this.configComponents = format != null ? format.getConfigComponents().stream().map(creator -> (SpecificConfigComponent)creator.apply(this)).toList() : Collections.emptyList();
        this.configComponents.forEach(c -> {
            Details details = new Details(c.getHeader(), (Component)c);
            details.setOpened(true);
            details.addThemeVariants((ThemeVariant[])new DetailsVariant[]{DetailsVariant.FILLED, DetailsVariant.SMALL});
            details.setWidthFull();
            this.vlConfigs.add(new Component[]{details});
        });
    }

    protected void bindConfigComponents(GridExporterWizardState<T> state, boolean deleteNonMatchingFromState) {
        for (SpecificConfigComponent<? extends SpecificConfig> specificConfigComponent : this.configComponents) {
            SpecificConfig newConfig = specificConfigComponent.getNewConfigSupplier().get();
            SpecificConfig existing = state.getSpecificConfigs().stream().filter(c -> Objects.equals(newConfig.getClass(), c.getClass())).findFirst().orElse(null);
            state.getSpecificConfigs().remove(existing);
            SpecificConfig configToUse = existing == null ? newConfig : existing;
            specificConfigComponent.updateFrom(configToUse);
            state.getSpecificConfigs().add(configToUse);
        }
        if (deleteNonMatchingFromState) {
            state.getSpecificConfigs().removeAll(state.getSpecificConfigs().stream().filter(ec -> this.configComponents.stream().map(SpecificConfigComponent::getBean).noneMatch(c -> Objects.equals(ec, c))).toList());
        }
    }

    protected void initBindings() {
        this.binder.forField(this.cbFormats).asRequired().bind(GridExporterWizardState::getSelectedFormat, GridExporterWizardState::setSelectedFormat);
    }

    @Override
    public void onEnterStep(GridExporterWizardState<T> state) {
        this.cbFormats.setItems(DataProvider.ofCollection(state.getAvailableFormats()));
        this.binder.setBean(state);
        this.bindConfigComponents(state, false);
    }

    @Override
    public boolean onProgress(GridExporterWizardState<T> state) {
        return this.binder.isValid() && this.configComponents.stream().allMatch(SpecificConfigComponent::isValid);
    }
}

