/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.jasper.config.encoding;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import java.io.Serializable;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.SpecificConfigComponent;
import software.xdev.vaadin.grid_exporter.jasper.config.encoding.EncodingConfig;
import software.xdev.vaadin.grid_exporter.jasper.config.encoding.ExportEncoding;

public class EncodingConfigComponent
extends SpecificConfigComponent<EncodingConfig> {
    protected final ComboBox<ExportEncoding> cbExportEncoding = new ComboBox();
    protected final Checkbox chbxUseBom = new Checkbox();

    public EncodingConfigComponent(Translator translator) {
        super(translator, EncodingConfig::new, "gridexporter.jasperformats.encoding");
        this.initUI();
        this.registerBindings();
    }

    protected void initUI() {
        this.cbExportEncoding.setItemLabelGenerator((ItemLabelGenerator & Serializable)ee -> ee.charset().name());
        this.chbxUseBom.setLabel(this.translate("gridexporter.jasperformats.with_bom"));
        ((FormLayout)this.getContent()).add(new Component[]{this.cbExportEncoding, this.chbxUseBom});
    }

    protected void registerBindings() {
        this.binder.forField(this.cbExportEncoding).asRequired().bind(EncodingConfig::getSelected, EncodingConfig::setSelected);
        this.cbExportEncoding.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.validateAndManageUseBOM((ExportEncoding)ev.getValue()));
        this.binder.forField((HasValue)this.chbxUseBom).bind(EncodingConfig::isUseBOM, EncodingConfig::setUseBOM);
    }

    protected void validateAndManageUseBOM(ExportEncoding value) {
        if (value == null) {
            return;
        }
        this.chbxUseBom.setEnabled(value.hasBom());
        if (!value.hasBom()) {
            this.chbxUseBom.setValue((Object)false);
        }
    }

    @Override
    public void updateFrom(EncodingConfig value) {
        this.cbExportEncoding.setItems(value.getAvailable());
        super.updateFrom(value);
    }
}

