/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.column.headerresolving;

import com.vaadin.flow.component.grid.Grid;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.xdev.vaadin.grid_exporter.column.headerresolving.ColumnHeaderResolvingStrategy;

public class ManualColumnHeaderResolvingStrategy<I>
implements ColumnHeaderResolvingStrategy {
    protected final Function<Grid.Column<?>, I> identifierResolver;
    protected final Map<I, Function<I, String>> headerTextResolverMap;

    public ManualColumnHeaderResolvingStrategy(Function<Grid.Column<?>, I> identifierResolver, Map<I, Function<I, String>> headerTextResolverMap) {
        this.identifierResolver = identifierResolver;
        this.headerTextResolverMap = headerTextResolverMap;
    }

    @Override
    public Optional<String> resolve(Grid.Column<?> column) {
        I identifier = this.identifierResolver.apply(column);
        Function<I, String> resolveFunction = this.headerTextResolverMap.get(identifier);
        if (resolveFunction == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(resolveFunction.apply(identifier));
    }
}

