/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.column;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.xdev.vaadin.grid_exporter.column.headerresolving.ColumnHeaderResolvingStrategy;
import software.xdev.vaadin.grid_exporter.column.headerresolving.ManualColumnHeaderResolvingStrategy;
import software.xdev.vaadin.grid_exporter.column.headerresolving.VaadinColumnHeaderResolvingStrategy;

public class ColumnConfigurationHeaderResolvingStrategyBuilder {
    protected final List<ColumnHeaderResolvingStrategy> strategies = new ArrayList<ColumnHeaderResolvingStrategy>();

    public ColumnConfigurationHeaderResolvingStrategyBuilder withVaadinInternalHeaderStrategy() {
        return this.withStrategy(new VaadinColumnHeaderResolvingStrategy());
    }

    public <I> ColumnConfigurationHeaderResolvingStrategyBuilder withManualColumnHeaderStrategy(Function<Grid.Column<?>, I> identifierResolver, Map<I, Function<I, String>> headerTextResolverMap) {
        return this.withStrategy(new ManualColumnHeaderResolvingStrategy<I>(identifierResolver, headerTextResolverMap));
    }

    public ColumnConfigurationHeaderResolvingStrategyBuilder withStrategy(ColumnHeaderResolvingStrategy strategy) {
        this.strategies.add(strategy);
        return this;
    }

    public ColumnConfigurationHeaderResolvingStrategyBuilder withFirstStrategy(ColumnHeaderResolvingStrategy strategy) {
        this.strategies.add(0, strategy);
        return this;
    }

    public ColumnConfigurationHeaderResolvingStrategyBuilder clearAllStrategies() {
        this.strategies.clear();
        return this;
    }

    public SerializableFunction<Grid.Column<?>, String> build() {
        return (SerializableFunction & Serializable)col -> {
            for (ColumnHeaderResolvingStrategy resolvingFunction : this.strategies) {
                Optional<String> optResolvedValue = resolvingFunction.resolve((Grid.Column<?>)col);
                if (!optResolvedValue.isPresent()) continue;
                return optResolvedValue.get();
            }
            return col.getKey() != null ? col.getKey() : "";
        };
    }
}

