/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.column;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.function.SerializableFunction;
import java.util.Objects;

public class ColumnConfiguration<T> {
    protected final Grid.Column<T> gridColumn;
    protected String header;

    public ColumnConfiguration(Grid.Column<T> gridColumn, SerializableFunction<Grid.Column<?>, String> headerResolver) {
        this.gridColumn = gridColumn;
        this.header = Objects.requireNonNullElse((String)headerResolver.apply(gridColumn), "");
    }

    public Grid.Column<T> getGridColumn() {
        return this.gridColumn;
    }

    public String getHeader() {
        return this.header;
    }

    public ColumnConfiguration<T> setHeader(String header) {
        this.header = Objects.requireNonNull(header);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration that = (ColumnConfiguration)o;
        return Objects.equals(this.gridColumn, that.gridColumn);
    }

    public int hashCode() {
        return Objects.hash(this.gridColumn);
    }
}

