/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.xdev.chartjs.model.dataset.Dataset;

public abstract class AbstractData<D extends AbstractData<D, T>, T extends Dataset<?, ?>> {
    private final List<String> labels = new ArrayList<String>();
    private final List<T> datasets = new ArrayList<T>();

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public D setLabels(Collection<String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
        return this.self();
    }

    public D setLabels(String ... labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(Arrays.asList(labels));
        }
        return this.self();
    }

    public D clearLabels() {
        this.labels.clear();
        return this.self();
    }

    public D addLabel(String label) {
        this.labels.add(label);
        return this.self();
    }

    public D addLabels(String ... label) {
        this.labels.addAll(Arrays.asList(label));
        return this.self();
    }

    public List<T> getDatasets() {
        return Collections.unmodifiableList(this.datasets);
    }

    public D setDatasets(Collection<T> datasets) {
        this.datasets.clear();
        if (datasets != null) {
            this.datasets.addAll(datasets);
        }
        return this.self();
    }

    public D addDataset(T dataset) {
        this.datasets.add(dataset);
        return this.self();
    }

    protected D self() {
        return (D)this;
    }
}

