/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocol.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Rpcv2CborTrait
extends AbstractTrait
implements ToSmithyBuilder<Rpcv2CborTrait> {
    public static final ShapeId ID = ShapeId.from((String)"smithy.protocols#rpcv2Cbor");
    private static final String HTTP = "http";
    private static final String EVENT_STREAM_HTTP = "eventStreamHttp";
    private final List<String> http;
    private final List<String> eventStreamHttp;

    private Rpcv2CborTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.http = ListUtils.copyOf((Collection)builder.http);
        this.eventStreamHttp = ListUtils.copyOf((Collection)builder.eventStreamHttp);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Rpcv2CborTrait fromNode(Node node) {
        Builder builder = (Builder)Rpcv2CborTrait.builder().sourceLocation((FromSourceLocation)node);
        ObjectNode objectNode = node.expectObjectNode();
        objectNode.getArrayMember(HTTP).map(values -> Node.loadArrayOfString((String)HTTP, (Node)values)).ifPresent(builder::http);
        objectNode.getArrayMember(EVENT_STREAM_HTTP).map(values -> Node.loadArrayOfString((String)EVENT_STREAM_HTTP, (Node)values)).ifPresent(builder::eventStreamHttp);
        return builder.build();
    }

    public List<String> getHttp() {
        return this.http;
    }

    public List<String> getEventStreamHttp() {
        return this.eventStreamHttp;
    }

    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation());
        if (!this.getHttp().isEmpty()) {
            builder.withMember(HTTP, (ToNode)Node.fromStrings(this.getHttp()));
        }
        if (!this.getEventStreamHttp().isEmpty()) {
            builder.withMember(EVENT_STREAM_HTTP, (ToNode)Node.fromStrings(this.getEventStreamHttp()));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return Rpcv2CborTrait.builder().http(this.http).eventStreamHttp(this.eventStreamHttp);
    }

    public static final class Builder
    extends AbstractTraitBuilder<Rpcv2CborTrait, Builder> {
        private final List<String> http = new ArrayList<String>();
        private final List<String> eventStreamHttp = new ArrayList<String>();

        public Rpcv2CborTrait build() {
            return new Rpcv2CborTrait(this);
        }

        public Builder http(List<String> http) {
            this.http.clear();
            this.http.addAll(http);
            return this;
        }

        public Builder eventStreamHttp(List<String> eventStreamHttp) {
            this.eventStreamHttp.clear();
            this.eventStreamHttp.addAll(eventStreamHttp);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Rpcv2CborTrait result = Rpcv2CborTrait.fromNode(value);
            result.setNodeCache(value);
            return result;
        }
    }
}

