/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ServiceRename
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        Walker oldWalker = new Walker(differences.getOldModel());
        return differences.changedShapes(ServiceShape.class).flatMap(diff -> {
            ServiceShape oldShape = (ServiceShape)diff.getOldShape();
            ServiceShape newShape = (ServiceShape)diff.getNewShape();
            if (oldShape.getRename().equals(newShape.getRename())) {
                return Stream.empty();
            }
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            for (Map.Entry old : oldShape.getRename().entrySet()) {
                String newValue = (String)newShape.getRename().get(old.getKey());
                if (newValue == null) {
                    events.add(this.error((Shape)newShape, String.format("Service rename of `%s` to `%s` was removed", old.getKey(), old.getValue())));
                    continue;
                }
                if (((String)old.getValue()).equals(newValue)) continue;
                events.add(this.error((Shape)newShape, String.format("Service rename of `%s` was changed from `%s` to `%s`", old.getKey(), old.getValue(), newValue)));
            }
            Set oldClosure = oldWalker.walkShapeIds((Shape)oldShape);
            for (Map.Entry newEntry : newShape.getRename().entrySet()) {
                if (oldShape.getRename().containsKey(newEntry.getKey()) || !oldClosure.contains(newEntry.getKey())) continue;
                events.add(this.error((Shape)newShape, String.format("Service rename of `%s` to `%s` was added to an old shape", newEntry.getKey(), newEntry.getValue())));
            }
            return events.stream();
        }).collect(Collectors.toList());
    }
}

