/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class AddedShape
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.addedShapes().filter(shape -> !this.isMemberOfAddedShape((Shape)shape, differences)).filter(shape -> !this.isMemberOfConvertedEnumShape((Shape)shape, differences)).map(shape -> this.note((Shape)shape, String.format("Added %s `%s`", shape.getType(), shape.getId()))).collect(Collectors.toList());
    }

    private boolean isMemberOfAddedShape(Shape shape, Differences differences) {
        return shape.asMemberShape().filter(member -> !differences.getOldModel().getShapeIds().contains(member.getContainer())).isPresent();
    }

    private boolean isMemberOfConvertedEnumShape(Shape shape, Differences differences) {
        if (!shape.asMemberShape().isPresent()) {
            return false;
        }
        ShapeId conversionShapeId = ((MemberShape)shape.asMemberShape().get()).getContainer();
        Optional<StringShape> oldStringShapeWithEnumTrait = differences.getOldModel().getShape(conversionShapeId).flatMap(Shape::asStringShape).filter(s -> s.getType() == ShapeType.STRING).filter(s -> s.hasTrait(EnumTrait.ID));
        Optional newEnumShape = differences.getNewModel().getShape(conversionShapeId).flatMap(Shape::asEnumShape);
        return newEnumShape.isPresent() && oldStringShapeWithEnumTrait.isPresent();
    }
}

