/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class RemovedShape
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.removedShapes().filter(shape -> !shape.hasTrait(PrivateTrait.class)).filter(shape -> !this.isMemberOfRemovedShape((Shape)shape, differences)).map(shape -> this.error((Shape)shape, String.format("Removed %s `%s`", shape.getType(), shape.getId()))).collect(Collectors.toList());
    }

    private boolean isMemberOfRemovedShape(Shape shape, Differences differences) {
        return shape.asMemberShape().filter(member -> !differences.getNewModel().getShapeIds().contains(member.getContainer())).isPresent();
    }
}

