/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.internal.DefaultMetricCollector;

public class MetricsCollector {
    private static final SdkMetric<Double> ACCESS_GRANT_CACHE_METRIC_HIT_RATE = SdkMetric.create((String)"AccessGrantsCacheHitRate", Double.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Double> ACCESS_DENIED_CACHE_METRIC_HIT_RATE = SdkMetric.create((String)"AccessDeniedCacheHitRate", Double.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Double> ACCOUNT_ID_RESOLVER_CACHE_METRIC_HIT_RATE = SdkMetric.create((String)"AccountIdResolverCacheHitRate", Double.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_GRANT_CACHE_METRIC_HIT_COUNT = SdkMetric.create((String)"AccessGrantsCacheHitCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_GRANT_CACHE_METRIC_MISS_COUNT = SdkMetric.create((String)"AccessGrantsCacheMissCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_GRANT_CACHE_METRIC_LOAD_COUNT = SdkMetric.create((String)"AccessGrantsCacheLoadCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_GRANT_CACHE_METRIC_LOAD_SUCCESS_COUNT = SdkMetric.create((String)"AccessGrantsCacheLoadSuccessCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_GRANT_CACHE_METRIC_EVICTION_COUNT = SdkMetric.create((String)"AccessGrantsCacheEvictionCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_DENIED_CACHE_METRIC_HIT_COUNT = SdkMetric.create((String)"AccessDeniedCacheHitCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_DENIED_CACHE_METRIC_MISS_COUNT = SdkMetric.create((String)"AccessDeniedCacheMissCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_DENIED_CACHE_METRIC_LOAD_COUNT = SdkMetric.create((String)"AccessDeniedCacheLoadCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_DENIED_CACHE_METRIC_LOAD_SUCCESS_COUNT = SdkMetric.create((String)"AccessDeniedCacheLoadSuccessCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCESS_DENIED_CACHE_METRIC_EVICTION_COUNT = SdkMetric.create((String)"AccessDeniedCacheEvictionCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCOUNT_ID_RESOLVER_CACHE_METRIC_HIT_COUNT = SdkMetric.create((String)"AccountIdResolverCacheHitCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCOUNT_ID_RESOLVER_CACHE_METRIC_MISS_COUNT = SdkMetric.create((String)"AccountIdResolverCacheMissCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCOUNT_ID_RESOLVER_CACHE_METRIC_LOAD_COUNT = SdkMetric.create((String)"AccountIdResolverCacheLoadCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCOUNT_ID_RESOLVER_CACHE_METRIC_LOAD_SUCCESS_COUNT = SdkMetric.create((String)"AccountIdResolverCacheLoadSuccessCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    private static final SdkMetric<Long> ACCOUNT_ID_RESOLVER_CACHE_METRIC_EVICTION_COUNT = SdkMetric.create((String)"AccountIdResolverCacheEvictionCount", Long.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    public static final SdkMetric<Integer> CALL_COUNT = SdkMetric.create((String)"CallCount", Integer.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    public static final SdkMetric<Integer> ERROR_COUNT = SdkMetric.create((String)"ErrorCount", Integer.class, (MetricLevel)MetricLevel.ERROR, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    public static final SdkMetric<Duration> LATENCY = SdkMetric.create((String)"Latency", Duration.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    public static final SdkMetric<Duration> searchKeyInCacheAtCharacterLevel_CacheHit_Latency = SdkMetric.create((String)"searchKeyInCacheAtCharacterLevel_CacheHit_Latency", Duration.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);
    public static final SdkMetric<Duration> searchKeyInCacheAtCharacterLevel_CacheMiss_Latency = SdkMetric.create((String)"searchKeyInCacheAtCharacterLevel_CacheMiss_Latency", Duration.class, (MetricLevel)MetricLevel.INFO, (MetricCategory)MetricCategory.CUSTOM, (MetricCategory[])new MetricCategory[0]);

    public static void getMetricsForAccessGrantsCache(CacheStats stats, DefaultMetricCollector collector) {
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_HIT_RATE, (Object)stats.hitRate());
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_HIT_COUNT, (Object)stats.hitCount());
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_MISS_COUNT, (Object)stats.missCount());
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_LOAD_COUNT, (Object)stats.loadCount());
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_LOAD_SUCCESS_COUNT, (Object)stats.loadSuccessCount());
        collector.reportMetric(ACCESS_GRANT_CACHE_METRIC_EVICTION_COUNT, (Object)stats.evictionCount());
    }

    public static void getMetricsForAccessDeniedCache(CacheStats stats, DefaultMetricCollector collector) {
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_HIT_RATE, (Object)stats.hitRate());
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_HIT_COUNT, (Object)stats.hitCount());
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_MISS_COUNT, (Object)stats.missCount());
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_LOAD_COUNT, (Object)stats.loadCount());
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_LOAD_SUCCESS_COUNT, (Object)stats.loadSuccessCount());
        collector.reportMetric(ACCESS_DENIED_CACHE_METRIC_EVICTION_COUNT, (Object)stats.evictionCount());
    }

    public static void getMetricsForAccountIdResolverCache(CacheStats stats, DefaultMetricCollector collector) {
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_HIT_RATE, (Object)stats.hitRate());
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_HIT_COUNT, (Object)stats.hitCount());
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_MISS_COUNT, (Object)stats.missCount());
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_LOAD_COUNT, (Object)stats.loadCount());
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_LOAD_SUCCESS_COUNT, (Object)stats.loadSuccessCount());
        collector.reportMetric(ACCOUNT_ID_RESOLVER_CACHE_METRIC_EVICTION_COUNT, (Object)stats.evictionCount());
    }
}

