/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.plugin.internal;

import java.util.HashMap;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsOperationToPermissionMapper;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsUtils;
import software.amazon.awssdk.services.s3control.model.Permission;

public class S3AccessGrantsStaticOperationToPermissionMapper
implements S3AccessGrantsOperationToPermissionMapper {
    private static final HashMap<String, Permission> supportedAccessGrantsOperations = new HashMap();

    @Override
    public Permission getPermission(@NotNull String operation) throws SdkServiceException {
        S3AccessGrantsUtils.argumentNotNull(operation, "An internal exception has occurred. expecting operation to be specified for the request. Please contact S3 access grants plugin team!");
        if (supportedAccessGrantsOperations.containsKey(operation.toUpperCase())) {
            return supportedAccessGrantsOperations.get(operation.toUpperCase());
        }
        throw SdkServiceException.builder().message("The requested operation cannot be completed!").statusCode(404).cause((Throwable)new UnsupportedOperationException("Access Grants does not support the requested operation!")).build();
    }

    static {
        supportedAccessGrantsOperations.put("HEADOBJECT", Permission.READ);
        supportedAccessGrantsOperations.put("GETOBJECT", Permission.READ);
        supportedAccessGrantsOperations.put("GETOBJECTACL", Permission.READ);
        supportedAccessGrantsOperations.put("LISTMULTIPARTUPLOADS", Permission.READ);
        supportedAccessGrantsOperations.put("LISTOBJECTS", Permission.READ);
        supportedAccessGrantsOperations.put("LISTOBJECTSV2", Permission.READ);
        supportedAccessGrantsOperations.put("LISTOBJECTVERSIONS", Permission.READ);
        supportedAccessGrantsOperations.put("LISTPARTS", Permission.READ);
        supportedAccessGrantsOperations.put("PUTOBJECT", Permission.WRITE);
        supportedAccessGrantsOperations.put("PUTOBJECTACL", Permission.WRITE);
        supportedAccessGrantsOperations.put("DELETEOBJECT", Permission.WRITE);
        supportedAccessGrantsOperations.put("ABORTMULTIPARTUPLOAD", Permission.WRITE);
        supportedAccessGrantsOperations.put("CREATEMULTIPARTUPLOAD", Permission.WRITE);
        supportedAccessGrantsOperations.put("UPLOADPART", Permission.WRITE);
        supportedAccessGrantsOperations.put("COMPLETEMULTIPARTUPLOAD", Permission.WRITE);
        supportedAccessGrantsOperations.put("DECRYPT", Permission.READ);
        supportedAccessGrantsOperations.put("GENERATEDATAKEY", Permission.WRITE);
    }
}

