/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.util.VisibleForTesting;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.internal.DefaultMetricCollector;
import software.amazon.awssdk.s3accessgrants.cache.CacheKey;
import software.amazon.awssdk.s3accessgrants.cache.MetricsCollector;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsAccessDeniedCache;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCache;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCachedAccountIdResolver;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCachedCredentialsProvider;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.utils.Logger;

public class S3AccessGrantsCachedCredentialsProviderImpl
implements S3AccessGrantsCachedCredentialsProvider {
    private final S3AccessGrantsCache accessGrantsCache;
    private final S3AccessGrantsAccessDeniedCache s3AccessGrantsAccessDeniedCache;
    DefaultMetricCollector collector = new DefaultMetricCollector("AccessGrantsMetricsCollector");
    public static final Logger logger = Logger.loggerFor(S3AccessGrantsCachedCredentialsProviderImpl.class);

    private S3AccessGrantsCachedCredentialsProviderImpl(S3ControlAsyncClient S3ControlAsyncClient2, int maxCacheSize, int cacheExpirationTimePercentage) {
        this.accessGrantsCache = S3AccessGrantsCache.builder().s3ControlAsyncClient(S3ControlAsyncClient2).maxCacheSize(maxCacheSize).cacheExpirationTimePercentage(cacheExpirationTimePercentage).build();
        this.s3AccessGrantsAccessDeniedCache = S3AccessGrantsAccessDeniedCache.builder().maxCacheSize(30000).build();
    }

    @VisibleForTesting
    S3AccessGrantsCachedCredentialsProviderImpl(S3ControlAsyncClient s3ControlAsyncClient, S3AccessGrantsCachedAccountIdResolver resolver, int maxCacheSize, int cacheExpirationTimePercentage) {
        this.accessGrantsCache = S3AccessGrantsCache.builder().s3ControlAsyncClient(s3ControlAsyncClient).maxCacheSize(maxCacheSize).cacheExpirationTimePercentage(cacheExpirationTimePercentage).s3AccessGrantsCachedAccountIdResolver(resolver).buildWithAccountIdResolver();
        this.s3AccessGrantsAccessDeniedCache = S3AccessGrantsAccessDeniedCache.builder().maxCacheSize(30000).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public CompletableFuture<AwsCredentialsIdentity> getDataAccess(AwsCredentialsIdentity credentials, Permission permission, String s3Prefix, @NotNull String accountId) throws S3ControlException {
        CompletableFuture<AwsCredentialsIdentity> accessGrantsCredentials;
        Instant start = Instant.now();
        CacheKey cacheKey = CacheKey.builder().credentials(credentials).permission(permission).s3Prefix(s3Prefix).build();
        S3ControlException s3ControlException = this.s3AccessGrantsAccessDeniedCache.getValueFromCache(cacheKey);
        if (s3ControlException != null) {
            logger.debug(() -> "Found a matching request in the cache which was denied.");
            logger.error(() -> "Exception occurred while fetching the credentials: " + s3ControlException);
            throw s3ControlException;
        }
        try {
            accessGrantsCredentials = this.accessGrantsCache.getCredentials(cacheKey, accountId, this.s3AccessGrantsAccessDeniedCache);
        }
        catch (S3ControlException e) {
            this.collector.reportMetric(MetricsCollector.ERROR_COUNT, (Object)1);
            throw e;
        }
        this.collector.reportMetric(MetricsCollector.LATENCY, (Object)Duration.between(start, Instant.now()));
        this.collector.reportMetric(MetricsCollector.CALL_COUNT, (Object)1);
        return accessGrantsCredentials;
    }

    public void invalidateCache() {
        this.accessGrantsCache.invalidateCache();
    }

    private void collectMetrics() {
        this.collector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessGrants");
        this.collector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Metrics");
        MetricsCollector.getMetricsForAccessGrantsCache(this.accessGrantsCache.getCacheStats(), this.collector);
        MetricsCollector.getMetricsForAccessDeniedCache(this.s3AccessGrantsAccessDeniedCache.getCacheStats(), this.collector);
        MetricsCollector.getMetricsForAccountIdResolverCache(this.accessGrantsCache.getS3AccessGrantsCachedAccountIdResolver().getCacheStats(), this.collector);
    }

    @Override
    public MetricCollector getAccessGrantsMetrics() {
        this.collectMetrics();
        return this.collector;
    }

    static final class BuilderImpl
    implements Builder {
        private S3ControlAsyncClient S3ControlAsyncClient;
        private S3AccessGrantsCachedAccountIdResolver s3AccessGrantsCachedAccountIdResolver;
        private int maxCacheSize = 30000;
        private int cacheExpirationTimePercentage = 90;

        private BuilderImpl() {
        }

        @Override
        public S3AccessGrantsCachedCredentialsProviderImpl build() {
            return new S3AccessGrantsCachedCredentialsProviderImpl(this.S3ControlAsyncClient, this.maxCacheSize, this.cacheExpirationTimePercentage);
        }

        @Override
        public S3AccessGrantsCachedCredentialsProviderImpl buildWithAccountIdResolver() {
            return new S3AccessGrantsCachedCredentialsProviderImpl(this.S3ControlAsyncClient, this.s3AccessGrantsCachedAccountIdResolver, this.maxCacheSize, this.cacheExpirationTimePercentage);
        }

        @Override
        public Builder S3ControlAsyncClient(S3ControlAsyncClient S3ControlAsyncClient2) {
            this.S3ControlAsyncClient = S3ControlAsyncClient2;
            return this;
        }

        @Override
        public Builder s3AccessGrantsCachedAccountIdResolver(S3AccessGrantsCachedAccountIdResolver s3AccessGrantsCachedAccountIdResolver) {
            this.s3AccessGrantsCachedAccountIdResolver = s3AccessGrantsCachedAccountIdResolver;
            return this;
        }

        @Override
        public Builder maxCacheSize(int maxCacheSize) {
            if (maxCacheSize <= 0 || maxCacheSize > 1000000) {
                throw new IllegalArgumentException(String.format("maxCacheSize needs to be in range (0, %d]", 1000000));
            }
            return this;
        }

        @Override
        public Builder cacheExpirationTimePercentage(int cacheExpirationTimePercentage) {
            if (cacheExpirationTimePercentage <= 0 || (float)cacheExpirationTimePercentage > 30000.0f) {
                throw new IllegalArgumentException(String.format("maxExpirationTimePercentage needs to be in range (0, %d]", 30000));
            }
            this.cacheExpirationTimePercentage = cacheExpirationTimePercentage;
            return this;
        }
    }

    public static interface Builder {
        public S3AccessGrantsCachedCredentialsProviderImpl build();

        public S3AccessGrantsCachedCredentialsProviderImpl buildWithAccountIdResolver();

        public Builder S3ControlAsyncClient(S3ControlAsyncClient var1);

        public Builder s3AccessGrantsCachedAccountIdResolver(S3AccessGrantsCachedAccountIdResolver var1);

        public Builder maxCacheSize(int var1);

        public Builder cacheExpirationTimePercentage(int var1);
    }
}

