/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import java.util.Objects;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.services.s3control.model.Permission;

public class CacheKey {
    final AwsCredentialsIdentity credentials;
    final Permission permission;
    final String s3Prefix;

    private CacheKey(AwsCredentialsIdentity credentials, Permission permission, String s3Prefix) {
        this.credentials = credentials;
        this.permission = permission;
        this.s3Prefix = s3Prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.credentials, cacheKey.credentials) && Objects.equals(this.s3Prefix, cacheKey.s3Prefix) && Objects.equals(this.permission, cacheKey.permission);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.permission, this.s3Prefix);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsCredentialsIdentity credentials;
        private Permission permission;
        private String s3Prefix;

        private BuilderImpl() {
        }

        public BuilderImpl(CacheKey CacheKey2) {
            this.credentials(CacheKey2.credentials);
            this.permission(CacheKey2.permission);
            this.s3Prefix(CacheKey2.s3Prefix);
        }

        @Override
        public CacheKey build() {
            return new CacheKey(this.credentials, this.permission, this.s3Prefix);
        }

        @Override
        public Builder credentials(AwsCredentialsIdentity credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder permission(Permission permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }
    }

    public static interface Builder {
        public CacheKey build();

        public Builder credentials(AwsCredentialsIdentity var1);

        public Builder permission(Permission var1);

        public Builder s3Prefix(String var1);
    }
}

