/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.testutils;

import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import java.util.Arrays;
import java.util.Random;

public class ShingledMultiDimDataWithKeys {
    public static MultiDimDataWithKey generateShingledDataWithKey(int size, int period, int shingleSize, int baseDimension, long seed) {
        boolean entryIndex = false;
        boolean filledShingleAtleastOnce = false;
        double[][] history = new double[shingleSize][];
        boolean count = false;
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData(size + shingleSize - 1, period, 100.0, 5.0, seed, baseDimension);
        double[][] answer = ShingledMultiDimDataWithKeys.generateShingledData(dataWithKeys.data, shingleSize, baseDimension, false);
        return new MultiDimDataWithKey(answer, dataWithKeys.changeIndices, dataWithKeys.changes);
    }

    public static double[][] generateShingledData(double[][] data, int shingleSize, int baseDimension, boolean rotation) {
        int size = data.length - shingleSize + 1;
        double[][] answer = new double[size][];
        int entryIndex = 0;
        boolean filledShingleAtleastOnce = false;
        double[][] history = new double[shingleSize][];
        int count = 0;
        for (int j = 0; j < size + shingleSize - 1; ++j) {
            history[entryIndex] = data[j];
            if ((entryIndex = (entryIndex + 1) % shingleSize) == 0) {
                filledShingleAtleastOnce = true;
            }
            if (!filledShingleAtleastOnce) continue;
            int position = rotation ? 0 : entryIndex;
            answer[count++] = ShingledMultiDimDataWithKeys.getShinglePoint(history, position, shingleSize, baseDimension);
        }
        return answer;
    }

    private static double[] getShinglePoint(double[][] recentPointsSeen, int indexOfOldestPoint, int shingleLength, int baseDimension) {
        double[] shingledPoint = new double[shingleLength * baseDimension];
        int count = 0;
        for (int j = 0; j < shingleLength; ++j) {
            double[] point = recentPointsSeen[(j + indexOfOldestPoint) % shingleLength];
            for (int i = 0; i < baseDimension; ++i) {
                shingledPoint[count++] = point[i];
            }
        }
        return shingledPoint;
    }

    public static MultiDimDataWithKey getMultiDimData(int num, int period, double amplitude, double noise, long seed, int baseDimension) {
        return ShingledMultiDimDataWithKeys.getMultiDimData(num, period, amplitude, noise, seed, baseDimension, false);
    }

    public static MultiDimDataWithKey getMultiDimData(int num, int period, double amplitude, double noise, long seed, int baseDimension, boolean useSlope) {
        int i;
        double[][] data = new double[num][];
        double[][] changes = new double[num][];
        int[] changedIndices = new int[num];
        int counter = 0;
        Random prg = new Random(seed);
        Random noiseprg = new Random(prg.nextLong());
        double[] phase = new double[baseDimension];
        double[] amp = new double[baseDimension];
        double[] slope = new double[baseDimension];
        double[] shift = new double[baseDimension];
        for (i = 0; i < baseDimension; ++i) {
            phase[i] = prg.nextInt(period);
            if (useSlope) {
                shift[i] = (4.0 * prg.nextDouble() - 1.0) * amplitude;
            }
            amp[i] = (1.0 + 0.2 * prg.nextDouble()) * amplitude;
            if (!useSlope) continue;
            slope[i] = (0.25 - prg.nextDouble() * 0.5) * amplitude / (double)period;
        }
        for (i = 0; i < num; ++i) {
            data[i] = new double[baseDimension];
            boolean flag = noiseprg.nextDouble() < 0.01;
            double[] newChange = new double[baseDimension];
            boolean used = false;
            for (int j = 0; j < baseDimension; ++j) {
                data[i][j] = amp[j] * Math.cos(Math.PI * 2 * ((double)i + phase[j]) / (double)period) + slope[j] * (double)i + noise * noiseprg.nextDouble() + shift[j];
                if (!flag || !(noiseprg.nextDouble() < 0.3)) continue;
                double factor = 5.0 * (1.0 + noiseprg.nextDouble());
                double change = noiseprg.nextDouble() < 0.5 ? factor * noise : -factor * noise;
                double[] dArray = data[i];
                int n = j;
                newChange[j] = change;
                dArray[n] = dArray[n] + newChange[j];
                used = true;
            }
            if (!used) continue;
            changedIndices[counter] = i;
            changes[counter++] = newChange;
        }
        return new MultiDimDataWithKey(data, Arrays.copyOf(changedIndices, counter), (double[][])Arrays.copyOf(changes, counter));
    }
}

