/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api.types;

import java.util.Arrays;

public enum AmazonSignatureAlgorithm {
    DEFAULT("AMZN-PAY-RSASSA-PSS", 20),
    V2("AMZN-PAY-RSASSA-PSS-V2", 32);

    private final String name;
    private final int saltLength;

    private AmazonSignatureAlgorithm(String name, int saltLength) {
        this.name = name;
        this.saltLength = saltLength;
    }

    public String getName() {
        return this.name;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public static AmazonSignatureAlgorithm returnIfValidAlgorithm(String algorithm) {
        return Arrays.stream(AmazonSignatureAlgorithm.values()).filter(signatureAlgorithm -> signatureAlgorithm.getName().equals(algorithm)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not a valid algorithm"));
    }
}

