/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.HttpDeleteWithBody;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.ProxySettings;
import com.amazon.pay.api.RequestConfig;
import com.amazon.pay.api.ServiceConstants;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.Environment;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String value, boolean path) throws AmazonPayClientException {
        if (value == null) {
            return "";
        }
        try {
            if (path) {
                value = value.replaceAll("/+", "/");
            }
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (path && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new AmazonPayClientException("Encountered UnsupportedEncodingException:", ex);
        }
    }

    public static String lowerCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.toLowerCase(Locale.ENGLISH);
    }

    public static String getFormattedTimestamp() {
        Date now = new Date();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return dateTimeFormat.format(now);
    }

    public static PrivateKey buildPrivateKey(char[] privateKey) throws AmazonPayClientException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (privateKey == null || privateKey.length == 0) {
            throw new AmazonPayClientException("Private key char array cannot be null or empty");
        }
        PemObject pemObject = Util.getPEMObjectFromKey(privateKey);
        if (pemObject == null) {
            throw new AmazonPayClientException("Private key string provided is not valid");
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pemObject.getContent());
        PrivateKey privateKeyObject = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKeyObject = keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return privateKeyObject;
    }

    private static PemObject getPEMObjectFromKey(char[] privateKey) throws AmazonPayClientException {
        PemObject pemObject;
        try {
            PemReader pemReader = new PemReader((Reader)new CharArrayReader(privateKey));
            pemObject = pemReader.readPemObject();
            pemReader.close();
        }
        catch (IOException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return pemObject;
    }

    public static URI getServiceURI(PayConfiguration payConfiguration, String action) throws AmazonPayClientException {
        URI uri;
        try {
            String endpoint = ServiceConstants.endpointMappings.get((Object)payConfiguration.getRegion());
            endpoint = payConfiguration.getOverrideServiceURL() != null ? "https://" + payConfiguration.getOverrideServiceURL() : ServiceConstants.endpointMappings.get((Object)payConfiguration.getRegion());
            uri = new URI(endpoint + Util.getServiceVersionName(payConfiguration, action));
        }
        catch (URISyntaxException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return uri;
    }

    private static String getServiceVersionName(PayConfiguration payConfiguration, String action) {
        String serviceVersionName = "";
        serviceVersionName = Util.serviceSupportsEnvPublicKeyId(payConfiguration) ? "/" + action : (payConfiguration.getEnvironment() == Environment.SANDBOX ? "/sandbox/" + action : "/live/" + action);
        return serviceVersionName;
    }

    private static boolean serviceSupportsEnvPublicKeyId(PayConfiguration payConfiguration) {
        return payConfiguration.getPublicKeyId().toUpperCase(Locale.ROOT).startsWith("LIVE") || payConfiguration.getPublicKeyId().toUpperCase(Locale.ROOT).startsWith("SANDBOX");
    }

    public static Map<String, String> updateHeader(Map<String, String> header) {
        if (header == null || header.isEmpty()) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("x-amz-pay-idempotency-key", UUID.randomUUID().toString().replace("-", ""));
            return headerMap;
        }
        boolean isIdempotencyKeyPresent = false;
        for (Map.Entry<String, String> entry : header.entrySet()) {
            if (!entry.getKey().toLowerCase().equals("x-amz-pay-idempotency-key")) continue;
            isIdempotencyKeyPresent = true;
            break;
        }
        if (!isIdempotencyKeyPresent) {
            header.put("x-amz-pay-idempotency-key", UUID.randomUUID().toString().replace("-", ""));
        }
        return header;
    }

    public static HttpUriRequest getHttpUriRequest(URI uri, String httpMethodName, String payload) throws AmazonPayClientException, UnsupportedEncodingException {
        switch (httpMethodName) {
            case "GET": {
                return new HttpGet(uri);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setEntity((HttpEntity)new StringEntity(payload, DEFAULT_ENCODING));
                return httpPost;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut(uri);
                httpPut.setEntity((HttpEntity)new StringEntity(payload, DEFAULT_ENCODING));
                return httpPut;
            }
            case "PATCH": {
                HttpPatch httpPatch = new HttpPatch(uri);
                httpPatch.setEntity((HttpEntity)new StringEntity(payload, DEFAULT_ENCODING));
                return httpPatch;
            }
            case "HEAD": {
                return new HttpHead(uri);
            }
            case "DELETE": {
                HttpDeleteWithBody httpDeleteWithBody = new HttpDeleteWithBody(uri);
                httpDeleteWithBody.setEntity((HttpEntity)new StringEntity(payload, DEFAULT_ENCODING));
                return httpDeleteWithBody;
            }
            case "OPTIONS": {
                return new HttpOptions(uri);
            }
            case "TRACE": {
                return new HttpTrace(uri);
            }
        }
        throw new AmazonPayClientException("Invalid HTTP method " + httpMethodName);
    }

    public static HttpClientBuilder getHttpClientBuilderWithProxy(ProxySettings proxySettings, PayConfiguration payConfiguration) {
        HttpHost proxy = new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort().intValue());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxySettings.getProxyUser(), String.valueOf(proxySettings.getProxyPassword()));
        AuthScope authScope = new AuthScope(proxySettings.getProxyHost(), proxySettings.getProxyPort().intValue());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setProxy(proxy);
        Util.applyRequestConfig(httpClientBuilder, payConfiguration);
        return httpClientBuilder;
    }

    public static AmazonPayResponse enhanceResponseWithShippingAddressList(AmazonPayResponse amazonPayResponse) throws AmazonPayClientException {
        try {
            JSONObject response = amazonPayResponse.getResponse();
            JSONArray shippingAddressList = response.optJSONArray("shippingAddressList");
            if (shippingAddressList != null) {
                for (int i = 0; i < shippingAddressList.length(); ++i) {
                    shippingAddressList.put(i, (Object)new JSONObject(shippingAddressList.getString(i)));
                }
                amazonPayResponse.setRawResponse(response.toString());
            }
        }
        catch (JSONException e) {
            throw new AmazonPayClientException(e.getMessage(), (Exception)((Object)e));
        }
        return amazonPayResponse;
    }

    protected static void applyRequestConfig(HttpClientBuilder httpClientBuilder, PayConfiguration payConfiguration) {
        if (Objects.nonNull(payConfiguration.getRequestConfig())) {
            RequestConfig apayRequestConfig = payConfiguration.getRequestConfig();
            org.apache.http.client.config.RequestConfig requestConfig = org.apache.http.client.config.RequestConfig.custom().setConnectTimeout(apayRequestConfig.getConnectTimeoutMillis()).setConnectionRequestTimeout(apayRequestConfig.getConnectionTimeoutMillis()).setSocketTimeout(apayRequestConfig.getSocketTimeoutMillis()).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

