/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.DefaultRetryStrategy;
import com.amazon.pay.api.ProxySettings;
import com.amazon.pay.api.RequestConfig;
import com.amazon.pay.api.RetryStrategy;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.AmazonSignatureAlgorithm;
import com.amazon.pay.api.types.Environment;
import com.amazon.pay.api.types.Region;
import java.security.PrivateKey;
import java.util.Objects;

public class PayConfiguration {
    private Region region;
    private String publicKeyId;
    private PrivateKey privateKey;
    private Environment environment;
    private AmazonSignatureAlgorithm algorithm;
    private boolean userAgentRedaction = false;
    private ProxySettings proxySettings;
    protected String overrideServiceURL;
    private int clientConnections;
    private RetryStrategy retryStrategy = new DefaultRetryStrategy();
    private RequestConfig requestConfig;

    public Region getRegion() {
        return this.region;
    }

    public PayConfiguration setRegion(Region region) {
        this.region = region;
        return this;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public PayConfiguration setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
        return this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public PayConfiguration setPrivateKey(String privateKey) throws AmazonPayClientException {
        return this.setPrivateKey(Util.buildPrivateKey(privateKey.toCharArray()));
    }

    public PayConfiguration setPrivateKey(char[] privateKey) throws AmazonPayClientException {
        return this.setPrivateKey(Util.buildPrivateKey(privateKey));
    }

    public PayConfiguration setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public AmazonSignatureAlgorithm getAlgorithm() {
        if (this.algorithm != null) {
            return this.algorithm;
        }
        return AmazonSignatureAlgorithm.DEFAULT;
    }

    public PayConfiguration setAlgorithm(String algorithm) {
        this.algorithm = AmazonSignatureAlgorithm.returnIfValidAlgorithm(algorithm);
        return this;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PayConfiguration setEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public int getMaxRetries() {
        return this.retryStrategy.getMaxRetries();
    }

    public PayConfiguration setMaxRetries(int maxRetries) {
        this.retryStrategy.setMaxRetries(maxRetries);
        return this;
    }

    public boolean isUserAgentRedaction() {
        return this.userAgentRedaction;
    }

    public PayConfiguration setUserAgentRedaction(boolean userAgentRedaction) {
        this.userAgentRedaction = userAgentRedaction;
        return this;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public PayConfiguration setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public String getOverrideServiceURL() {
        return this.overrideServiceURL;
    }

    public int getClientConnections() {
        if (this.clientConnections != 0) {
            return this.clientConnections;
        }
        return 20;
    }

    public PayConfiguration setClientConnections(int clientConnections) {
        this.clientConnections = clientConnections;
        return this;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public PayConfiguration setRetryStrategy(RetryStrategy retryStrategy) {
        Objects.requireNonNull(retryStrategy, "retryStrategy must not be null");
        this.retryStrategy = retryStrategy;
        return this;
    }

    public PayConfiguration setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }
}

