/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayClient;
import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import java.net.URI;
import java.util.Map;
import org.json.JSONObject;

public class AccountManagementClient
extends AmazonPayClient {
    public AccountManagementClient(PayConfiguration payConfiguration) throws AmazonPayClientException {
        super(payConfiguration);
    }

    public AmazonPayResponse createMerchantAccount(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createMerchantAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createMerchantAccountURI, "POST", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse updateMerchantAccount(String merchantAccountId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI merchantAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        URI updateMerchantAccountURI = merchantAccountURI.resolve(merchantAccountURI.getPath() + "/" + merchantAccountId);
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(updateMerchantAccountURI, "PATCH", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse merchantAccountClaim(String merchantAccountId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI merchantAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        URI merchantAccountClaimURI = merchantAccountURI.resolve(merchantAccountURI.getPath() + "/" + merchantAccountId + "/claim");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(merchantAccountClaimURI, "POST", null, payload.toString(), headerMap);
    }
}

