/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto.impl;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class KmsAsymmetricRSASSAProvider
extends BaseJWSProvider {
    @NonNull
    private final AWSKMS kms;
    @NonNull
    private final String privateKeyId;
    @NonNull
    private final MessageType messageType;
    public static final Map<JWSAlgorithm, String> JWS_ALGORITHM_TO_MESSAGE_DIGEST_ALGORITHM = ImmutableMap.builder().put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_256.toString()), (Object)"SHA-256").put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_384.toString()), (Object)"SHA-384").put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_512.toString()), (Object)"SHA-512").put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PSS_SHA_256.toString()), (Object)"SHA-256").put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PSS_SHA_384.toString()), (Object)"SHA-384").put((Object)JWSAlgorithm.parse((String)SigningAlgorithmSpec.RSASSA_PSS_SHA_512.toString()), (Object)"SHA-512").build();
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS = JWS_ALGORITHM_TO_MESSAGE_DIGEST_ALGORITHM.keySet();

    protected KmsAsymmetricRSASSAProvider(@NonNull AWSKMS kms, @NonNull String privateKeyId, @NonNull MessageType messageType) {
        super(SUPPORTED_ALGORITHMS);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(privateKeyId, "privateKeyId is marked non-null but is null");
        Objects.requireNonNull(messageType, "messageType is marked non-null but is null");
        this.kms = kms;
        this.privateKeyId = privateKeyId;
        this.messageType = messageType;
    }

    protected ByteBuffer getMessage(JWSHeader header, byte[] signingInput) throws JOSEException {
        JWSAlgorithm alg = header.getAlgorithm();
        byte[] message = signingInput;
        String messageDigestAlgorithm = Optional.ofNullable(JWS_ALGORITHM_TO_MESSAGE_DIGEST_ALGORITHM.get(alg)).orElseThrow(() -> new JOSEException(String.format("No digest algorithm exist for JWE algorithm %s in map: %s", alg, JWS_ALGORITHM_TO_MESSAGE_DIGEST_ALGORITHM)));
        if (this.messageType == MessageType.DIGEST) {
            MessageDigest messageDigestProvider;
            try {
                messageDigestProvider = MessageDigest.getInstance(messageDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new JOSEException("Invalid message digest algorithm.", (Throwable)e);
            }
            message = messageDigestProvider.digest(message);
        }
        return ByteBuffer.wrap(message);
    }

    @NonNull
    @Generated
    protected AWSKMS getKms() {
        return this.kms;
    }

    @NonNull
    @Generated
    protected String getPrivateKeyId() {
        return this.privateKeyId;
    }

    @NonNull
    @Generated
    protected MessageType getMessageType() {
        return this.messageType;
    }
}

