/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.aws.kms.crypto;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.DependencyTimeoutException;
import com.amazonaws.services.kms.model.DisabledException;
import com.amazonaws.services.kms.model.InvalidGrantTokenException;
import com.amazonaws.services.kms.model.InvalidKeyUsageException;
import com.amazonaws.services.kms.model.KMSInternalException;
import com.amazonaws.services.kms.model.KMSInvalidStateException;
import com.amazonaws.services.kms.model.KeyUnavailableException;
import com.amazonaws.services.kms.model.NotFoundException;
import com.nimbusds.jose.CriticalHeaderParamsAware;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.aws.kms.crypto.impl.KmsSymmetricCryptoProvider;
import com.nimbusds.jose.aws.kms.exceptions.TemporaryJOSEException;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.jca.JWEJCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

@ThreadSafe
public class KmsSymmetricDecrypter
extends KmsSymmetricCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public KmsSymmetricDecrypter(@NonNull AWSKMS kms, @NonNull String keyId, @NonNull Map<String, String> encryptionContext) {
        super(kms, keyId, encryptionContext);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        Objects.requireNonNull(encryptionContext, "encryptionContext is marked non-null but is null");
    }

    public KmsSymmetricDecrypter(@NonNull AWSKMS kms, @NonNull String keyId) {
        super(kms, keyId);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
    }

    public KmsSymmetricDecrypter(@NonNull AWSKMS kms, @NonNull String keyId, @NonNull Set<String> defCritHeaders) {
        this(kms, keyId);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        Objects.requireNonNull(defCritHeaders, "defCritHeaders is marked non-null but is null");
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public KmsSymmetricDecrypter(@NonNull AWSKMS kms, @NonNull String keyId, @NonNull Map<String, String> encryptionContext, @NonNull Set<String> defCritHeaders) {
        this(kms, keyId, encryptionContext);
        Objects.requireNonNull(kms, "kms is marked non-null but is null");
        Objects.requireNonNull(keyId, "keyId is marked non-null but is null");
        Objects.requireNonNull(encryptionContext, "encryptionContext is marked non-null but is null");
        Objects.requireNonNull(defCritHeaders, "defCritHeaders is marked non-null but is null");
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getDeferredCriticalHeaderParams();
    }

    public byte[] decrypt(@NonNull JWEHeader header, @NonNull Base64URL encryptedKey, @NonNull Base64URL iv, @NonNull Base64URL cipherText, @NonNull Base64URL authTag) throws JOSEException {
        Objects.requireNonNull(header, "header is marked non-null but is null");
        Objects.requireNonNull(encryptedKey, "encryptedKey is marked non-null but is null");
        Objects.requireNonNull(iv, "iv is marked non-null but is null");
        Objects.requireNonNull(cipherText, "cipherText is marked non-null but is null");
        Objects.requireNonNull(authTag, "authTag is marked non-null but is null");
        this.validateJWEHeader(header);
        this.critPolicy.ensureHeaderPasses(header);
        DecryptResult cekDecryptResult = this.decryptCek(this.getKeyId(), this.getEncryptionContext(), encryptedKey);
        SecretKeySpec cek = new SecretKeySpec(cekDecryptResult.getPlaintext().array(), header.getAlgorithm().toString());
        return ContentCryptoProvider.decrypt((JWEHeader)header, (Base64URL)encryptedKey, (Base64URL)iv, (Base64URL)cipherText, (Base64URL)authTag, (SecretKey)cek, (JWEJCAContext)this.getJCAContext());
    }

    private DecryptResult decryptCek(String keyId, Map<String, String> encryptionContext, Base64URL encryptedKey) throws JOSEException {
        try {
            return this.getKms().decrypt(new DecryptRequest().withEncryptionContext(encryptionContext).withKeyId(keyId).withCiphertextBlob(ByteBuffer.wrap(encryptedKey.decode())));
        }
        catch (DisabledException | InvalidKeyUsageException | KMSInvalidStateException | KeyUnavailableException | NotFoundException e) {
            throw new RemoteKeySourceException("An exception was thrown from KMS due to invalid key.", e);
        }
        catch (DependencyTimeoutException | InvalidGrantTokenException | KMSInternalException e) {
            throw new TemporaryJOSEException("A temporary error was thrown from KMS.", e);
        }
    }
}

